/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeDataInputStream {
    private final DataInputStream dis;

    public SafeDataInputStream(InputStream is) {
        this.dis = new DataInputStream(is);
    }

    public int readInt() {
        try {
            return this.dis.readInt();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public String readString() {
        try {
            int length = this.dis.readInt();
            byte[] data = new byte[length];
            this.dis.readFully(data);
            return new String(data, "UTF-8");
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public <T> T read(Class<T> type) {
        return (T)IsolationUtils.fromXml(this.readString());
    }

    public void close() {
        try {
            this.dis.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public byte readByte() {
        try {
            return this.dis.readByte();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public boolean readBoolean() {
        try {
            return this.dis.readBoolean();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public long readLong() {
        try {
            return this.dis.readLong();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }
}

