/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeDataOutputStream {
    private final DataOutputStream dos;

    public SafeDataOutputStream(OutputStream os) {
        this.dos = new DataOutputStream(os);
    }

    public void writeInt(int value) {
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeString(String str) {
        try {
            byte[] data = str.getBytes("UTF-8");
            this.dos.writeInt(data.length);
            this.dos.write(data);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public <T> void write(T value) {
        this.writeString(IsolationUtils.toXml(value));
    }

    public void flush() {
        try {
            this.dos.flush();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeByte(byte b) {
        try {
            this.dos.writeByte(b);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeBoolean(boolean b) {
        try {
            this.dos.writeBoolean(b);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeLong(long l) {
        try {
            this.dos.writeLong(l);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }
}

