/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Logger;
import org.pitest.util.Log;

public class SocketFinder {
    private static final Logger LOG = Log.getLogger();
    private static final int MIN_PORT_NUMBER = 8091;
    private static final int MAX_PORT_NUMBER = 9000;
    private int lastPortNumber = 8091;

    public synchronized ServerSocket getNextAvailableServerSocket() {
        ++this.lastPortNumber;
        ServerSocket socket = SocketFinder.getIfAvailable(this.lastPortNumber);
        while (socket == null) {
            ++this.lastPortNumber;
            if (this.lastPortNumber > 9000) {
                this.lastPortNumber = 9000;
            }
            socket = SocketFinder.getIfAvailable(this.lastPortNumber);
        }
        LOG.fine("using port " + this.lastPortNumber);
        return socket;
    }

    private static synchronized ServerSocket getIfAvailable(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
        }
        catch (IOException e) {
            LOG.fine("port " + port + " is in use");
        }
        return ss;
    }
}

