/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import org.pitest.functional.SideEffect1;
import org.pitest.util.ExitCode;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataInputStream;
import org.pitest.util.SafeDataOutputStream;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketReadingCallable
implements Callable<ExitCode> {
    private final SideEffect1<SafeDataOutputStream> sendInitialData;
    private final ReceiveStrategy receive;
    private final ServerSocket socket;

    public SocketReadingCallable(ServerSocket socket, SideEffect1<SafeDataOutputStream> sendInitialData, ReceiveStrategy receive) {
        this.socket = socket;
        this.sendInitialData = sendInitialData;
        this.receive = receive;
    }

    @Override
    public ExitCode call() throws Exception {
        Socket clientSocket = this.socket.accept();
        ExitCode exitCode = ExitCode.UNKNOWN_ERROR;
        try {
            BufferedInputStream bif = new BufferedInputStream(clientSocket.getInputStream());
            this.sendDataToSlave(clientSocket);
            SafeDataInputStream is = new SafeDataInputStream(bif);
            exitCode = this.receiveResults(is);
            bif.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
        finally {
            try {
                if (clientSocket != null) {
                    clientSocket.close();
                }
                this.socket.close();
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException(e);
            }
        }
        return exitCode;
    }

    private void sendDataToSlave(Socket clientSocket) throws IOException {
        OutputStream os = clientSocket.getOutputStream();
        SafeDataOutputStream dos = new SafeDataOutputStream(os);
        this.sendInitialData.apply(dos);
    }

    private ExitCode receiveResults(SafeDataInputStream is) {
        byte control = is.readByte();
        while (control != 64) {
            this.receive.apply(control, is);
            control = is.readByte();
        }
        return ExitCode.fromCode(is.readInt());
    }
}

