/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.pitest.functional.SideEffect1;
import org.pitest.util.Log;
import org.pitest.util.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamMonitor
extends Thread
implements Monitor {
    private static final Logger LOG = Log.getLogger();
    private final byte[] buf = new byte[256];
    private final InputStream in;
    private final SideEffect1<String> inputHandler;

    public StreamMonitor(InputStream in, SideEffect1<String> inputHandler) {
        super("PIT Stream Monitor");
        this.in = in;
        this.inputHandler = inputHandler;
        this.setDaemon(true);
    }

    @Override
    public void requestStart() {
        this.start();
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            this.readFromStream();
        }
    }

    private void readFromStream() {
        try {
            int i;
            if (this.in.available() == 0) {
                Thread.sleep(100L);
                return;
            }
            while ((i = this.in.read(this.buf, 0, this.buf.length)) != -1) {
                String output = new String(this.buf, 0, i);
                this.inputHandler.apply(output);
            }
        }
        catch (IOException e) {
            this.requestStop();
            LOG.fine("No longer able to read stream.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void requestStop() {
        this.interrupt();
    }
}

