/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.maven.PitMojo;
import org.pitest.mutationtest.config.ConfigurationFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoToReportOptionsConverter {
    private final PitMojo mojo;
    private final Predicate<Artifact> dependencyFilter;

    public MojoToReportOptionsConverter(PitMojo mojo, Predicate<Artifact> dependencyFilter) {
        this.mojo = mojo;
        this.dependencyFilter = dependencyFilter;
    }

    public ReportOptions convert() {
        ArrayList<String> classPath = new ArrayList<String>();
        try {
            classPath.addAll(this.mojo.getProject().getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e1) {
            this.mojo.getLog().info((Throwable)e1);
        }
        this.addOwnDependenciesToClassPath(classPath);
        classPath.addAll(this.mojo.getAdditionalClasspathElements());
        return this.parseReportOptions(classPath);
    }

    private ReportOptions parseReportOptions(List<String> classPath) {
        ReportOptions data = new ReportOptions();
        if (this.mojo.getProject().getBuild() != null) {
            Log.getLogger().info("Mutating from " + this.mojo.getProject().getBuild().getOutputDirectory());
            data.setCodePaths(Collections.singleton(this.mojo.getProject().getBuild().getOutputDirectory()));
        }
        data.setClassPathElements(classPath);
        data.setDependencyAnalysisMaxDistance(this.mojo.getMaxDependencyDistance());
        data.setFailWhenNoMutations(this.shouldFailWhenNoMutations());
        data.setTargetClasses(this.determineTargetClasses());
        data.setTargetTests(this.determineTargetTests());
        data.setMutateStaticInitializers(this.mojo.isMutateStaticInitializers());
        data.setExcludedMethods(this.globStringsToPredicates(this.mojo.getExcludedMethods()));
        data.setExcludedClasses(this.globStringsToPredicates(this.mojo.getExcludedClasses()));
        data.setNumberOfThreads(this.mojo.getThreads());
        data.setMaxMutationsPerClass(this.mojo.getMaxMutationsPerClass());
        data.setReportDir(this.mojo.getReportsDirectory().getAbsolutePath());
        data.setVerbose(this.mojo.isVerbose());
        if (this.mojo.getJvmArgs() != null) {
            data.addChildJVMArgs(this.mojo.getJvmArgs());
        }
        data.setMutators(this.determineMutators());
        data.setTimeoutConstant(this.mojo.getTimeoutConstant());
        data.setTimeoutFactor(this.mojo.getTimeoutFactor());
        if (this.hasValue(this.mojo.getAvoidCallsTo())) {
            data.setLoggingClasses(this.mojo.getAvoidCallsTo());
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        sourceRoots.addAll(this.mojo.getProject().getCompileSourceRoots());
        sourceRoots.addAll(this.mojo.getProject().getTestCompileSourceRoots());
        data.setSourceDirs(this.stringsTofiles(sourceRoots));
        data.addOutputFormats(this.determineOutputFormats());
        this.setTestType(data);
        data.setMutationUnitSize(this.mojo.getMutationUnitSize());
        data.setShouldCreateTimestampedReports(this.mojo.isTimestampedReports());
        data.setDetectInlinedCode(this.mojo.isDetectInlinedCode());
        data.setHistoryInputLocation(this.mojo.getHistoryInputFile());
        data.setHistoryOutputLocation(this.mojo.getHistoryOutputFile());
        data.setExportLineCoverage(this.mojo.isExportLineCoverage());
        data.setMutationEngine(this.mojo.getMutationEngine());
        data.setJavaExecutable(this.mojo.getJavaExecutable());
        return data;
    }

    private boolean shouldFailWhenNoMutations() {
        return this.mojo.isFailWhenNoMutations();
    }

    private void setTestType(ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.mojo.getExcludedGroups(), this.mojo.getIncludedGroups());
        ConfigurationFactory configFactory = new ConfigurationFactory(conf, (ClassByteArraySource)new ClassPathByteArraySource(data.getClassPath()));
        data.setGroupConfig(conf);
        data.setConfiguration(configFactory.createConfiguration());
    }

    private void addOwnDependenciesToClassPath(List<String> classPath) {
        for (Artifact dependency : this.filteredDependencies()) {
            classPath.add(dependency.getFile().getAbsolutePath());
        }
    }

    private Collection<Predicate<String>> globStringsToPredicates(List<String> excludedMethods) {
        return FCollection.map(excludedMethods, (F)Glob.toGlobPredicate());
    }

    private Collection<Predicate<String>> determineTargetTests() {
        return FCollection.map(this.mojo.getTargetTests(), (F)Glob.toGlobPredicate());
    }

    private Collection<Artifact> filteredDependencies() {
        return FCollection.filter(this.mojo.getPluginArtifactMap().values(), this.dependencyFilter);
    }

    private Collection<String> determineMutators() {
        if (this.mojo.getMutators() != null) {
            return this.mojo.getMutators();
        }
        return Collections.emptyList();
    }

    private Collection<Predicate<String>> determineTargetClasses() {
        return this.returnOrDefaultToClassesLikeGroupName(this.mojo.getTargetClasses());
    }

    private Collection<Predicate<String>> returnOrDefaultToClassesLikeGroupName(Collection<String> filters) {
        if (!this.hasValue(filters)) {
            String groupId = this.mojo.getProject().getGroupId() + "*";
            this.mojo.getLog().info((CharSequence)("Defaulting to group id (" + groupId + ")"));
            return Collections.singleton(new Glob(groupId));
        }
        return FCollection.map(filters, (F)Glob.toGlobPredicate());
    }

    private Collection<File> stringsTofiles(List<String> sourceRoots) {
        return FCollection.map(sourceRoots, this.stringToFile());
    }

    private F<String, File> stringToFile() {
        return new F<String, File>(){

            public File apply(String a) {
                return new File(a);
            }
        };
    }

    private Collection<String> determineOutputFormats() {
        if (this.hasValue(this.mojo.getOutputFormats())) {
            return this.mojo.getOutputFormats();
        }
        return Arrays.asList("HTML");
    }

    private boolean hasValue(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }
}

