/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.pitest.coverage.CoverageSummary;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.GoalStrategy;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.RunPitStrategy;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.plugin.ToolClasspathPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitMojo
extends AbstractMojo {
    protected final Predicate<Artifact> filter;
    protected final PluginServices plugins;
    protected ArrayList<String> targetClasses;
    protected ArrayList<String> targetTests;
    private ArrayList<String> excludedMethods;
    private ArrayList<String> excludedClasses;
    private ArrayList<String> avoidCallsTo;
    private File reportsDirectory;
    private File historyOutputFile;
    private File historyInputFile;
    private int maxDependencyDistance;
    private int threads;
    private boolean mutateStaticInitializers;
    private boolean detectInlinedCode;
    private ArrayList<String> mutators;
    private float timeoutFactor;
    private long timeoutConstant;
    private int maxMutationsPerClass;
    private ArrayList<String> jvmArgs;
    private ArrayList<String> outputFormats;
    private boolean verbose;
    private boolean failWhenNoMutations;
    private boolean timestampedReports;
    private ArrayList<String> excludedGroups;
    private ArrayList<String> includedGroups;
    private int mutationUnitSize;
    private boolean exportLineCoverage;
    private int mutationThreshold;
    private int coverageThreshold;
    private String jvm;
    private String mutationEngine;
    private ArrayList<String> additionalClasspathElements;
    protected MavenProject project;
    private Map<String, Artifact> pluginArtifactMap;
    protected final GoalStrategy goalStrategy;

    public PitMojo() {
        this(new RunPitStrategy(), new DependencyFilter(new PluginServices(PitMojo.class.getClassLoader())), new PluginServices(PitMojo.class.getClassLoader()));
    }

    public PitMojo(GoalStrategy strategy, Predicate<Artifact> filter, PluginServices plugins) {
        this.goalStrategy = strategy;
        this.filter = filter;
        this.plugins = plugins;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldRun()) {
            for (ToolClasspathPlugin each : this.plugins.findToolClasspathPlugins()) {
                this.getLog().info((CharSequence)("Found plugin : " + each.description()));
            }
            for (ToolClasspathPlugin each : this.plugins.findClientClasspathPlugins()) {
                this.getLog().info((CharSequence)("Found shared classpath plugin : " + each.description()));
            }
            Option<CombinedStatistics> result = this.analyse();
            if (result.hasSome()) {
                this.throwErrorIfScoreBelowThreshold(((CombinedStatistics)result.value()).getMutationStatistics());
                this.throwErrorIfCoverageBelowThreshold(((CombinedStatistics)result.value()).getCoverageSummary());
            }
        } else {
            this.getLog().info((CharSequence)"Skipping project");
        }
    }

    private void throwErrorIfCoverageBelowThreshold(CoverageSummary coverageSummary) throws MojoFailureException {
        if (this.coverageThreshold != 0 && coverageSummary.getCoverage() < this.coverageThreshold) {
            throw new MojoFailureException("Line coverage of " + coverageSummary.getCoverage() + " is below threshold of " + this.coverageThreshold);
        }
    }

    private void throwErrorIfScoreBelowThreshold(MutationStatistics result) throws MojoFailureException {
        if (this.mutationThreshold != 0 && result.getPercentageDetected() < (long)this.mutationThreshold) {
            throw new MojoFailureException("Mutation score of " + result.getPercentageDetected() + " is below threshold of " + this.mutationThreshold);
        }
    }

    protected Option<CombinedStatistics> analyse() throws MojoExecutionException {
        ReportOptions data = new MojoToReportOptionsConverter(this, this.filter).convert();
        return Option.some((Object)this.goalStrategy.execute(this.detectBaseDir(), data, this.plugins));
    }

    protected File detectBaseDir() {
        MavenProject executionProject = this.project.getExecutionProject();
        if (executionProject == null) {
            return null;
        }
        return executionProject.getBasedir();
    }

    public List<String> getTargetClasses() {
        return this.targetClasses;
    }

    public List<String> getTargetTests() {
        return this.targetTests;
    }

    public List<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public List<String> getAvoidCallsTo() {
        return this.avoidCallsTo;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getMaxDependencyDistance() {
        return this.maxDependencyDistance;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isMutateStaticInitializers() {
        return this.mutateStaticInitializers;
    }

    public List<String> getMutators() {
        return this.mutators;
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public long getTimeoutConstant() {
        return this.timeoutConstant;
    }

    public int getMaxMutationsPerClass() {
        return this.maxMutationsPerClass;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public List<String> getOutputFormats() {
        return this.outputFormats;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public boolean isFailWhenNoMutations() {
        return this.failWhenNoMutations;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public List<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public int getMutationUnitSize() {
        return this.mutationUnitSize;
    }

    public boolean isTimestampedReports() {
        return this.timestampedReports;
    }

    public boolean isDetectInlinedCode() {
        return this.detectInlinedCode;
    }

    public void setTimestampedReports(boolean timestampedReports) {
        this.timestampedReports = timestampedReports;
    }

    public File getHistoryOutputFile() {
        return this.historyOutputFile;
    }

    public File getHistoryInputFile() {
        return this.historyInputFile;
    }

    public boolean isExportLineCoverage() {
        return this.exportLineCoverage;
    }

    protected boolean shouldRun() {
        return !this.project.getPackaging().equalsIgnoreCase("pom");
    }

    public String getMutationEngine() {
        return this.mutationEngine;
    }

    public String getJavaExecutable() {
        return this.jvm;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.jvm = javaExecutable;
    }

    public List<String> getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }
}

