/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jline.Terminal;
import jline.TerminalFactory;
import org.apache.logging.log4j.Level;
import sbt.internal.util.ConsoleAppender;
import sbt.internal.util.ConsoleOut;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.LogOption;
import sbt.internal.util.LogOption$Always$;
import sbt.internal.util.LogOption$Auto$;
import sbt.internal.util.LogOption$Never$;
import sbt.internal.util.SuppressedTraceContext;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class ConsoleAppender$ {
    public static ConsoleAppender$ MODULE$;
    private final String CursorDown1;
    private final AtomicInteger widthHolder;
    private final AtomicBoolean showProgressHolder;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final boolean formatEnabledInEnv;
    private final AtomicInteger generateId;

    static {
        new ConsoleAppender$();
    }

    public String cursorUp(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("A").toString();
    }

    public String cursorDown(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("B").toString();
    }

    public String scrollUp(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("S").toString();
    }

    public final String DeleteLine() {
        return "\u001b[2K";
    }

    public final String CursorLeft1000() {
        return "\u001b[1000D";
    }

    public final String CursorDown1() {
        return this.CursorDown1;
    }

    public int terminalWidth() {
        return this.widthHolder.get();
    }

    public void setTerminalWidth(int n) {
        this.widthHolder.set(n);
    }

    public void setShowProgress(boolean b) {
        this.showProgressHolder.set(b);
    }

    public boolean showProgress() {
        return this.showProgressHolder.get();
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    public boolean formatEnabledInEnv() {
        return this.formatEnabledInEnv;
    }

    public LogOption parseLogOption(String s) {
        String string = s.toLowerCase();
        LogOption logOption = "always".equals(string) ? LogOption$Always$.MODULE$ : ("auto".equals(string) ? LogOption$Auto$.MODULE$ : ("never".equals(string) ? LogOption$Never$.MODULE$ : ("true".equals(string) ? LogOption$Always$.MODULE$ : ("false".equals(string) ? LogOption$Never$.MODULE$ : LogOption$Auto$.MODULE$))));
        return logOption;
    }

    public ConsoleAppender apply() {
        return this.apply(ConsoleOut$.MODULE$.systemOut());
    }

    public ConsoleAppender apply(PrintStream out) {
        return this.apply(ConsoleOut$.MODULE$.printStreamOut(out));
    }

    public ConsoleAppender apply(PrintWriter out) {
        return this.apply(ConsoleOut$.MODULE$.printWriterOut(out));
    }

    public ConsoleAppender apply(ConsoleOut out) {
        return this.apply(this.generateName(), out);
    }

    public ConsoleAppender apply(String name) {
        return this.apply(name, ConsoleOut$.MODULE$.systemOut());
    }

    public ConsoleAppender apply(String name, ConsoleOut out) {
        return this.apply(name, out, this.formatEnabledInEnv());
    }

    public ConsoleAppender apply(String name, ConsoleOut out, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return this.apply(name, out, this.formatEnabledInEnv(), this.formatEnabledInEnv(), suppressedMessage);
    }

    public ConsoleAppender apply(String name, ConsoleOut out, boolean useFormat) {
        return this.apply(name, out, this.formatEnabledInEnv(), useFormat, this.noSuppressedMessage());
    }

    public ConsoleAppender apply(String name, ConsoleOut out, boolean ansiCodesSupported, boolean useFormat, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        ConsoleAppender appender = new ConsoleAppender(name, out, ansiCodesSupported, useFormat, suppressedMessage);
        appender.start();
        return appender;
    }

    public Enumeration.Value toLevel(Level level) {
        Enumeration.Value value;
        Level level2 = level;
        Level level3 = Level.OFF;
        Level level4 = level2;
        if (!(level3 != null ? !level3.equals(level4) : level4 != null)) {
            value = Level$.MODULE$.Debug();
        } else {
            Level level5 = Level.FATAL;
            Level level6 = level2;
            if (!(level5 != null ? !level5.equals(level6) : level6 != null)) {
                value = Level$.MODULE$.Error();
            } else {
                Level level7 = Level.ERROR;
                Level level8 = level2;
                if (!(level7 != null ? !level7.equals(level8) : level8 != null)) {
                    value = Level$.MODULE$.Error();
                } else {
                    Level level9 = Level.WARN;
                    Level level10 = level2;
                    if (!(level9 != null ? !level9.equals(level10) : level10 != null)) {
                        value = Level$.MODULE$.Warn();
                    } else {
                        Level level11 = Level.INFO;
                        Level level12 = level2;
                        if (!(level11 != null ? !level11.equals(level12) : level12 != null)) {
                            value = Level$.MODULE$.Info();
                        } else {
                            Level level13 = Level.DEBUG;
                            Level level14 = level2;
                            value = !(level13 != null ? !level13.equals(level14) : level14 != null) ? Level$.MODULE$.Debug() : Level$.MODULE$.Debug();
                        }
                    }
                }
            }
        }
        return value;
    }

    public Level toXLevel(Enumeration.Value level) {
        Level level2;
        Enumeration.Value value = level;
        Enumeration.Value value2 = Level$.MODULE$.Error();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            level2 = Level.ERROR;
        } else {
            Enumeration.Value value4 = Level$.MODULE$.Warn();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                level2 = Level.WARN;
            } else {
                Enumeration.Value value6 = Level$.MODULE$.Info();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    level2 = Level.INFO;
                } else {
                    Enumeration.Value value8 = Level$.MODULE$.Debug();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        level2 = Level.DEBUG;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return level2;
    }

    public String generateName() {
        return new StringBuilder(4).append("out-").append(this.generateId.incrementAndGet()).toString();
    }

    private String jline1to2CompatMsg() {
        return "Found class jline.Terminal, but interface was expected";
    }

    private boolean ansiSupported() {
        boolean bl;
        try {
            Terminal terminal = TerminalFactory.get();
            terminal.restore();
            bl = terminal.isAnsiSupported();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof Exception)) {
                if (throwable2 instanceof IncompatibleClassChangeError) {
                    IncompatibleClassChangeError incompatibleClassChangeError = (IncompatibleClassChangeError)throwable2;
                    String string = incompatibleClassChangeError.getMessage();
                    String string2 = this.jline1to2CompatMsg();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new IncompatibleClassChangeError("JLine incompatibility detected.  Check that the sbt launcher is version 0.13.x or later.");
                    }
                }
                throw throwable;
            }
            boolean bl2 = !this.isWindows();
            bl = bl2;
        }
        return bl;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    private final boolean useColorDefault$1() {
        boolean hasConsole = Option$.MODULE$.apply((Object)System.console()).isDefined();
        return this.ansiSupported() && hasConsole;
    }

    private ConsoleAppender$() {
        MODULE$ = this;
        this.CursorDown1 = this.cursorDown(1);
        this.widthHolder = new AtomicInteger();
        this.showProgressHolder = new AtomicBoolean(false);
        this.noSuppressedMessage = (Function1 & Serializable & scala.Serializable)x$1 -> None$.MODULE$;
        Option option = package$.MODULE$.props().get("sbt.log.noformat");
        boolean bl = option instanceof Some ? !Boolean.getBoolean("sbt.log.noformat") : BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.props().get("sbt.color").orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.props().get("sbt.colour")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.props().get("sbt.log.format")).flatMap((Function1 & Serializable & scala.Serializable)s -> {
            LogOption logOption = MODULE$.parseLogOption((String)s);
            Object object = LogOption$Always$.MODULE$.equals(logOption) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : (LogOption$Never$.MODULE$.equals(logOption) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$);
            return object;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.useColorDefault$1()));
        this.formatEnabledInEnv = bl;
        this.generateId = new AtomicInteger();
    }
}

