/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.FarmHash;
import sbt.internal.inc.FarmHash$FromString$;
import sbt.internal.inc.Hash;
import sbt.internal.inc.Hash$FromString$;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.LastModified$;
import sbt.internal.inc.StampBase;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.Equiv;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.analysis.Stamp;

public final class Stamp$ {
    public static final Stamp$ MODULE$ = new Stamp$();
    private static final Equiv<Stamp> equivStamp = new Equiv<Stamp>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equiv(Stamp a, Stamp b) {
            Tuple2 tuple2 = new Tuple2((Object)a, (Object)b);
            if (tuple2 != null) {
                Stamp h1 = (Stamp)tuple2._1();
                Stamp h2 = (Stamp)tuple2._2();
                if (h1 instanceof FarmHash) {
                    FarmHash farmHash = (FarmHash)h1;
                    if (h2 instanceof FarmHash) {
                        FarmHash farmHash2 = (FarmHash)h2;
                        if (farmHash.hashValue() != farmHash2.hashValue()) return false;
                        return true;
                    }
                }
            }
            if (tuple2 != null) {
                Stamp h1 = (Stamp)tuple2._1();
                Stamp h2 = (Stamp)tuple2._2();
                if (h1 instanceof Hash) {
                    Hash hash = (Hash)h1;
                    if (h2 instanceof Hash) {
                        Hash hash2 = (Hash)h2;
                        String string = hash.hexHash();
                        String string2 = hash2.hexHash();
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }
            }
            if (tuple2 != null) {
                Stamp lm1 = (Stamp)tuple2._1();
                Stamp lm2 = (Stamp)tuple2._2();
                if (lm1 instanceof LastModified) {
                    LastModified lastModified = (LastModified)lm1;
                    if (lm2 instanceof LastModified) {
                        LastModified lastModified2 = (LastModified)lm2;
                        if (lastModified.value() == lastModified2.value()) return true;
                        if (Math.abs(lastModified.value() - lastModified2.value()) >= 100L) return false;
                        return true;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Stamp stampA = (Stamp)tuple2._1();
            Stamp stampB = (Stamp)tuple2._2();
            if (stampA != EmptyStamp$.MODULE$) return false;
            if (stampB != EmptyStamp$.MODULE$) return false;
            return true;
        }
    };

    private final long maxModificationDifferenceInMillis() {
        return 100L;
    }

    public Equiv<Stamp> equivStamp() {
        return equivStamp;
    }

    public Stamp fromString(String s) {
        Option option;
        Option<Hash> option2;
        Option<FarmHash> option3;
        StampBase stampBase;
        String string = s;
        if ("absent".equals(string)) {
            stampBase = EmptyStamp$.MODULE$;
        } else if (string != null && !(option3 = FarmHash$FromString$.MODULE$.unapply(string)).isEmpty()) {
            FarmHash hash = (FarmHash)option3.get();
            stampBase = hash;
        } else if (string != null && !(option2 = Hash$FromString$.MODULE$.unapply(string)).isEmpty()) {
            Hash hash = (Hash)option2.get();
            stampBase = hash;
        } else if (string != null && !(option = LastModified$.MODULE$.Pattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String value = (String)((LinearSeqOps)option.get()).apply(0);
            stampBase = new LastModified(Long.parseLong(value));
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Unrecognized Stamp string representation: ").append(s).toString());
        }
        return stampBase;
    }

    public Stamp getStamp(Map<File, Stamp> map, File src) {
        return (Stamp)map.getOrElse((Object)src, (Function0 & Serializable)() -> EmptyStamp$.MODULE$);
    }

    public Stamp getVStamp(Map<VirtualFileRef, Stamp> map, VirtualFile src) {
        return (Stamp)map.getOrElse((Object)src, (Function0 & Serializable)() -> EmptyStamp$.MODULE$);
    }

    public Stamp getVOStamp(Map<VirtualFileRef, Stamp> map, VirtualFileRef src) {
        return (Stamp)map.getOrElse((Object)src, (Function0 & Serializable)() -> EmptyStamp$.MODULE$);
    }

    private Stamp$() {
    }
}

