/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerProcessor;
import org.simpleframework.transport.Processor;
import org.simpleframework.transport.ProcessorServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.Socket;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.FileAllocator;

public class ContainerServer
implements Server {
    private final Processor processor;
    private final Server server;

    public ContainerServer(Container container) throws IOException {
        this(container, 8);
    }

    public ContainerServer(Container container, int count) throws IOException {
        this(container, count, 1);
    }

    public ContainerServer(Container container, int count, int select) throws IOException {
        this(container, new FileAllocator(), count, select);
    }

    public ContainerServer(Container container, Allocator allocator) throws IOException {
        this(container, allocator, 8);
    }

    public ContainerServer(Container container, Allocator allocator, int count) throws IOException {
        this(container, allocator, count, 1);
    }

    public ContainerServer(Container container, Allocator allocator, int count, int select) throws IOException {
        this.processor = new ContainerProcessor(container, allocator, count, select);
        this.server = new ProcessorServer(this.processor, count);
    }

    public void process(Socket socket) throws IOException {
        this.server.process(socket);
    }

    public void stop() throws IOException {
        this.server.stop();
    }
}

