/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Part;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.QueryBuilder;
import org.simpleframework.http.core.RequestMessage;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestEntity
extends RequestMessage
implements Request {
    private QueryBuilder builder;
    private Channel channel;
    private Query query;
    private Body body;
    private Map map;
    private long time;

    public RequestEntity(Entity entity, Monitor monitor) {
        this.builder = new QueryBuilder(this, entity);
        this.channel = entity.getChannel();
        this.header = entity.getHeader();
        this.body = entity.getBody();
        this.time = entity.getTime();
    }

    @Override
    public boolean isSecure() {
        return this.channel.isSecure();
    }

    @Override
    public boolean isKeepAlive() {
        String value = this.getValue("Connection");
        if (value == null) {
            int major = this.getMajor();
            int minor = this.getMinor();
            if (major > 1) {
                return true;
            }
            if (major == 1) {
                return minor > 0;
            }
            return false;
        }
        return !value.equalsIgnoreCase("close");
    }

    @Override
    public long getRequestTime() {
        return this.time;
    }

    @Override
    public SSLSession getSecuritySession() {
        SSLEngine engine = this.channel.getEngine();
        if (engine != null) {
            return engine.getSession();
        }
        return null;
    }

    @Override
    public InetSocketAddress getClientAddress() {
        SocketChannel socket = this.channel.getSocket();
        Socket client = socket.socket();
        return this.getClientAddress(client);
    }

    private InetSocketAddress getClientAddress(Socket socket) {
        InetAddress address = socket.getInetAddress();
        int port = socket.getPort();
        return new InetSocketAddress(address, port);
    }

    @Override
    public String getContent() throws IOException {
        ContentType type = this.getContentType();
        if (type == null) {
            return this.body.getContent("ISO-8859-1");
        }
        return this.getContent(type);
    }

    public String getContent(ContentType type) throws IOException {
        String charset = type.getCharset();
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return this.body.getContent(charset);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.body.getInputStream();
    }

    @Override
    public ReadableByteChannel getByteChannel() throws IOException {
        InputStream source = this.getInputStream();
        if (source != null) {
            return Channels.newChannel(source);
        }
        return null;
    }

    @Override
    public Map getAttributes() {
        Map common = this.channel.getAttributes();
        if (this.map == null) {
            this.map = new HashMap(common);
        }
        return this.map;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.getAttributes().get(key);
    }

    @Override
    public Query getQuery() {
        if (this.query == null) {
            this.query = this.builder.build();
        }
        return this.query;
    }

    @Override
    public String getParameter(String name) {
        return (String)this.getQuery().get(name);
    }

    @Override
    public Part getPart(String name) {
        return this.body.getPart(name);
    }

    @Override
    public List<Part> getParts() {
        return this.body.getParts();
    }
}

