/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Producer;
import org.simpleframework.http.core.ProducerFactory;
import org.simpleframework.http.core.TransferException;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class Transfer {
    private ProducerFactory factory;
    private Conversation support;
    private Response response;
    private Producer producer;
    private Trace trace;

    public Transfer(Response response, Conversation support, Channel channel, Monitor monitor) {
        this.factory = new ProducerFactory(support, channel, monitor);
        this.trace = channel.getTrace();
        this.response = response;
        this.support = support;
    }

    public boolean isStarted() {
        return this.producer != null;
    }

    public void start() throws IOException {
        if (this.producer != null) {
            throw new TransferException("Transfer has already started");
        }
        this.clear();
        this.configure();
        this.commit();
    }

    public void start(int length) throws IOException {
        if (this.producer != null) {
            throw new TransferException("Transfer has already started");
        }
        this.clear();
        this.configure(length);
        this.commit();
    }

    public void write(byte[] array) throws IOException {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int off, int len) throws IOException {
        if (this.producer == null) {
            throw new TransferException("Conversation details not ready");
        }
        this.trace.trace((Object)ContainerEvent.WRITE_BODY, len);
        this.producer.produce(array, off, len);
    }

    public void write(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new TransferException("Buffer position greater than limit");
        }
        this.write(buffer, 0, size - mark);
    }

    public void write(ByteBuffer buffer, int off, int len) throws IOException {
        if (this.producer == null) {
            throw new TransferException("Conversation details not ready");
        }
        this.trace.trace((Object)ContainerEvent.WRITE_BODY, len);
        this.producer.produce(buffer, off, len);
    }

    public void flush() throws IOException {
        if (this.producer == null) {
            throw new TransferException("Conversation details not ready");
        }
        this.producer.flush();
    }

    public void close() throws IOException {
        if (this.producer == null) {
            throw new TransferException("Conversation details not ready");
        }
        this.producer.close();
    }

    private void configure() throws IOException {
        long length = this.support.getContentLength();
        boolean empty = this.support.isEmpty();
        if (empty) {
            this.support.setContentLength(0L);
        } else if (length >= 0L) {
            this.support.setContentLength(length);
        } else {
            this.support.setChunkedEncoded();
        }
        this.producer = this.factory.getInstance();
    }

    private void configure(long count) throws IOException {
        long length = this.support.getContentLength();
        if (this.support.isHead()) {
            if (count > 0L) {
                this.configure(count, count);
            } else {
                this.configure(count, length);
            }
        } else {
            this.configure(count, count);
        }
    }

    private void configure(long count, long length) throws IOException {
        boolean empty = this.support.isEmpty();
        if (empty) {
            this.support.setContentLength(0L);
        } else if (length >= 0L) {
            this.support.setContentLength(length);
        } else {
            this.support.setChunkedEncoded();
        }
        this.producer = this.factory.getInstance();
    }

    private void clear() throws IOException {
        this.support.setIdentityEncoded();
    }

    private void commit() throws IOException {
        try {
            this.response.commit();
        }
        catch (Exception cause) {
            throw new TransferException("Unable to commit", cause);
        }
    }
}

