/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Queue;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketException;

class BufferSegment
implements Packet {
    private final Packet packet;
    private final Queue queue;

    public BufferSegment(Packet packet, Queue queue) {
        this.packet = packet;
        this.queue = queue;
    }

    public int space() {
        return this.packet.space();
    }

    public long sequence() {
        return this.packet.sequence();
    }

    public int capacity() {
        return this.packet.capacity();
    }

    public int length() {
        return this.packet.length();
    }

    public int compareTo(Packet other) {
        return this.packet.compareTo(other);
    }

    public Packet extract() throws IOException {
        return this.packet.extract();
    }

    public String encode() throws IOException {
        return this.packet.encode();
    }

    public String encode(String encoding) throws IOException {
        return this.packet.encode(encoding);
    }

    public int append(ByteBuffer buffer) throws IOException {
        return this.packet.append(buffer);
    }

    public int append(ByteBuffer buffer, int count) throws IOException {
        return this.packet.append(buffer, count);
    }

    public int write(ByteChannel channel) throws IOException {
        return this.packet.write(channel);
    }

    public int write(ByteChannel channel, int count) throws IOException {
        return this.packet.write(channel, count);
    }

    public boolean isReference() {
        return this.packet.isReference();
    }

    public void close() throws IOException {
        Object top = this.queue.peek();
        if (top != this.packet) {
            throw new PacketException("Close out of sequence");
        }
        this.packet.close();
        this.queue.poll();
    }

    public String toString() {
        return ((Object)this.packet).toString();
    }
}

