/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.AbstractModule;
import java.net.URL;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.ILoggerFactory;
import org.sonatype.maven.mojo.logback.ErrorNoticeAppender;
import org.sonatype.maven.mojo.logback.LogbackUtils;
import org.sonatype.maven.mojo.logback.MavenAppender;

public class LogbackModule
extends AbstractModule {
    private final LoggerContext loggerContext = new LoggerContext();
    private final ErrorNoticeAppender errorDetector;

    public LogbackModule(Log log) {
        this.fillContext(this.loggerContext);
        URL logbackConfigurationUrl = this.getLogbackConfiguration();
        if (logbackConfigurationUrl != null) {
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)this.loggerContext);
                configurator.doConfigure(logbackConfigurationUrl);
            }
            catch (JoranException e) {
                // empty catch block
            }
        }
        this.errorDetector = new ErrorNoticeAppender();
        this.errorDetector.setContext((Context)this.loggerContext);
        this.errorDetector.start();
        MavenAppender mavenBridge = new MavenAppender(log);
        mavenBridge.setContext((Context)this.loggerContext);
        mavenBridge.start();
        Logger root = this.loggerContext.getLogger("ROOT");
        LogbackUtils.syncLogLevelWithMaven(root, log);
        root.addAppender((Appender)this.errorDetector);
        root.addAppender((Appender)mavenBridge);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.loggerContext);
    }

    public boolean hasErrors() {
        return this.errorDetector.hasErrors();
    }

    protected void fillContext(LoggerContext loggerContext) {
    }

    protected URL getLogbackConfiguration() {
        return null;
    }

    protected void configureRootLogger(Logger rootLogger) {
    }

    protected void configure() {
        this.binder().bind(ILoggerFactory.class).toInstance((Object)this.loggerContext);
    }
}

