/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import org.sonatype.spice.zapper.Range;
import org.sonatype.spice.zapper.internal.Check;

public abstract class AbstractRange
implements Range {
    private final long offset;
    private final long length;

    protected AbstractRange(long offset, long length) {
        this.offset = Check.argument(offset >= 0L, offset, "Offset is less than 0!");
        this.length = Check.argument(length > 0L, length, "Length is less than 1!");
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean matches(Range range) {
        return this.getOffset() == range.getOffset() && this.getLength() == range.getLength();
    }

    public boolean contains(Range range) {
        return this.getOffset() <= range.getOffset() && this.getLength() >= range.getLength();
    }

    public boolean overlaps(Range range) {
        long myStart = this.getOffset();
        long myEnd = myStart + this.getLength();
        long hisStart = range.getOffset();
        long hisEnd = hisStart + range.getLength();
        return myEnd >= hisStart && myStart <= hisEnd;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(offset=" + this.getOffset() + ", length=" + this.getLength() + ")";
    }
}

