/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.UninitializedMessageException;
import org.sonatype.spice.zapper.internal.hawtbuf.Hash;
import org.sonatype.spice.zapper.internal.hawtbuf.SegmentFooterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SegmentFooter
extends SegmentFooterBase<SegmentFooter> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasMagic()) {
            missingFields.add("magic");
        }
        if (this.hasHashes()) {
            List l = this.getHashesList();
            for (int i = 0; i < l.size(); ++i) {
                try {
                    ((Hash)((Object)l.get(i))).assertInitialized();
                    continue;
                }
                catch (UninitializedMessageException e) {
                    missingFields.addAll(this.prefix(e.getMissingFields(), "hashes[" + i + "]"));
                }
            }
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearMagic();
        this.clearHashes();
    }

    public SegmentFooter clone() {
        return new SegmentFooter().mergeFrom(this);
    }

    public SegmentFooter mergeFrom(SegmentFooter other) {
        if (other.hasMagic()) {
            this.setMagic(other.getMagic());
        }
        if (other.hasHashes()) {
            for (Hash element : other.getHashesList()) {
                this.getHashesList().add(element.clone());
            }
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasMagic()) {
            size += CodedOutputStream.computeStringSize((int)1, (String)this.getMagic());
        }
        if (this.hasHashes()) {
            for (Hash i : this.getHashesList()) {
                size += SegmentFooter.computeMessageSize((int)2, (BaseMessage)i);
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public SegmentFooter mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block5: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block5;
                }
                case 10: {
                    this.setMagic(input.readString());
                    continue block5;
                }
                case 18: 
            }
            this.getHashesList().add(new Hash().mergeFramed(input));
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasMagic()) {
            output.writeString(1, this.getMagic());
        }
        if (this.hasHashes()) {
            for (Hash i : this.getHashesList()) {
                SegmentFooter.writeMessage((CodedOutputStream)output, (int)2, (BaseMessage)i);
            }
        }
    }

    public static SegmentFooter parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentFooter)((Object)new SegmentFooter().mergeUnframed(data).checktInitialized());
    }

    public static SegmentFooter parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentFooter parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentFooter parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeUnframed(data))).checktInitialized());
    }

    public static SegmentFooter parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeFramed(data))).checktInitialized());
    }

    public static SegmentFooter parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeFramed(data))).checktInitialized());
    }

    public static SegmentFooter parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeFramed(data))).checktInitialized());
    }

    public static SegmentFooter parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (SegmentFooter)((Object)((SegmentFooter)((Object)new SegmentFooter().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasMagic()) {
            sb.append(prefix + "magic: ");
            sb.append(this.getMagic());
            sb.append("\n");
        }
        if (this.hasHashes()) {
            List l = this.getHashesList();
            for (int i = 0; i < l.size(); ++i) {
                sb.append(prefix + "hashes[" + i + "] {\n");
                ((Hash)((Object)l.get(i))).toString(sb, prefix + "  ");
                sb.append(prefix + "}\n");
            }
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != SegmentFooter.class) {
            return false;
        }
        return this.equals((SegmentFooter)((Object)obj));
    }

    public boolean equals(SegmentFooter obj) {
        if (this.hasMagic() ^ obj.hasMagic()) {
            return false;
        }
        if (this.hasMagic() && !this.getMagic().equals(obj.getMagic())) {
            return false;
        }
        if (this.hasHashes() ^ obj.hasHashes()) {
            return false;
        }
        return !this.hasHashes() || this.getHashesList().equals(obj.getHashesList());
    }

    public int hashCode() {
        int rc = -525205874;
        if (this.hasMagic()) {
            rc ^= 0x46AB98D ^ this.getMagic().hashCode();
        }
        if (this.hasHashes()) {
            rc ^= 0x8069AE5C ^ this.getHashesList().hashCode();
        }
        return rc;
    }
}

