/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.sonatype.spice.zapper.internal.hawtbuf.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SegmentFooterBase<T>
extends BaseMessage<T> {
    private String f_magic = "zSef";
    private boolean b_magic;
    private List<Hash> f_hashes;

    SegmentFooterBase() {
    }

    public boolean hasMagic() {
        return this.b_magic;
    }

    public String getMagic() {
        return this.f_magic;
    }

    public T setMagic(String magic) {
        this.loadAndClear();
        this.b_magic = true;
        this.f_magic = magic;
        return (T)((Object)this);
    }

    public void clearMagic() {
        this.loadAndClear();
        this.b_magic = false;
        this.f_magic = "zSef";
    }

    public boolean hasHashes() {
        return this.f_hashes != null && !this.f_hashes.isEmpty();
    }

    public List<Hash> getHashesList() {
        if (this.f_hashes == null) {
            this.f_hashes = new ArrayList<Hash>();
        }
        return this.f_hashes;
    }

    public T setHashesList(List<Hash> hashes) {
        this.loadAndClear();
        this.f_hashes = hashes;
        return (T)((Object)this);
    }

    public int getHashesCount() {
        if (this.f_hashes == null) {
            return 0;
        }
        return this.f_hashes.size();
    }

    public Hash getHashes(int index) {
        if (this.f_hashes == null) {
            return null;
        }
        return this.f_hashes.get(index);
    }

    public T setHashes(int index, Hash value) {
        this.loadAndClear();
        this.getHashesList().set(index, value);
        return (T)((Object)this);
    }

    public T addHashes(Hash value) {
        this.loadAndClear();
        this.getHashesList().add(value);
        return (T)((Object)this);
    }

    public T addAllHashes(Iterable<? extends Hash> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getHashesList());
        return (T)((Object)this);
    }

    public void clearHashes() {
        this.loadAndClear();
        this.f_hashes = null;
    }
}

