/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.util.Assert;

public final class ElasticsearchDateConverter {
    private static final ConcurrentHashMap<String, ElasticsearchDateConverter> converters = new ConcurrentHashMap();
    private final DateFormatter dateFormatter;

    public static ElasticsearchDateConverter of(DateFormat dateFormat) {
        Assert.notNull((Object)((Object)dateFormat), (String)"dateFormat must not be null");
        return ElasticsearchDateConverter.of(dateFormat.name());
    }

    public static ElasticsearchDateConverter of(String pattern) {
        Assert.notNull((Object)pattern, (String)"pattern must not be null");
        return converters.computeIfAbsent(pattern, p -> new ElasticsearchDateConverter(DateFormatter.forPattern((String)p)));
    }

    private ElasticsearchDateConverter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String format(TemporalAccessor accessor) {
        Assert.notNull((Object)accessor, (String)"accessor must not be null");
        return this.dateFormatter.format(accessor);
    }

    public String format(Date date) {
        Assert.notNull((Object)date, (String)"accessor must not be null");
        return this.dateFormatter.format((TemporalAccessor)Instant.ofEpochMilli(date.getTime()));
    }

    public <T extends TemporalAccessor> T parse(String input, Class<T> type) {
        ZonedDateTime zonedDateTime = DateFormatters.from((TemporalAccessor)this.dateFormatter.parse(input));
        try {
            Method method = type.getMethod("from", TemporalAccessor.class);
            Object o = method.invoke(null, zonedDateTime);
            return (T)((TemporalAccessor)type.cast(o));
        }
        catch (NoSuchMethodException e) {
            throw new ConversionException("no 'from' factory method found in class " + type.getName());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConversionException("could not create object of class " + type.getName(), e);
        }
    }

    public Date parse(String input) {
        ZonedDateTime zonedDateTime = DateFormatters.from((TemporalAccessor)this.dateFormatter.parse(input));
        return new Date(Instant.from(zonedDateTime).toEpochMilli());
    }
}

