/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import org.elasticsearch.index.VersionType;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.lang.Nullable;

public interface ElasticsearchPersistentEntity<T>
extends PersistentEntity<T, ElasticsearchPersistentProperty> {
    public IndexCoordinates getIndexCoordinates();

    public short getShards();

    public short getReplicas();

    public boolean isUseServerConfiguration();

    @Nullable
    public String getRefreshInterval();

    @Nullable
    public String getIndexStoreType();

    public ElasticsearchPersistentProperty getVersionProperty();

    @Nullable
    public String getParentType();

    @Nullable
    public ElasticsearchPersistentProperty getParentIdProperty();

    public String settingPath();

    @Nullable
    public VersionType getVersionType();

    public boolean isCreateIndexAndMapping();

    @Deprecated
    public boolean hasScoreProperty();

    @Nullable
    @Deprecated
    public ElasticsearchPersistentProperty getScoreProperty();

    @Nullable
    public ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String var1);

    public boolean hasSeqNoPrimaryTermProperty();

    @Nullable
    public ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty();

    default public ElasticsearchPersistentProperty getRequiredSeqNoPrimaryTermProperty() {
        ElasticsearchPersistentProperty property = this.getSeqNoPrimaryTermProperty();
        if (property != null) {
            return property;
        }
        throw new IllegalStateException(String.format("Required SeqNoPrimaryTerm property not found for %s!", this.getType()));
    }
}

