/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.support;

import javax.ejb.EnterpriseBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.access.ContextJndiBeanFactoryLocator;
import org.springframework.util.WeakReferenceMonitor;

abstract class AbstractEnterpriseBean
implements EnterpriseBean {
    public static final String BEAN_FACTORY_PATH_ENVIRONMENT_KEY = "java:comp/env/ejb/BeanFactoryPath";
    private BeanFactoryLocator beanFactoryLocator;
    private String beanFactoryLocatorKey;
    private BeanFactoryReference beanFactoryReference;
    static /* synthetic */ Class class$org$springframework$beans$factory$access$BeanFactoryReference;

    AbstractEnterpriseBean() {
    }

    public void setBeanFactoryLocator(BeanFactoryLocator beanFactoryLocator) {
        this.beanFactoryLocator = beanFactoryLocator;
    }

    public void setBeanFactoryLocatorKey(String factoryKey) {
        this.beanFactoryLocatorKey = factoryKey;
    }

    void loadBeanFactory() throws BeansException {
        if (this.beanFactoryLocator == null) {
            this.beanFactoryLocator = new ContextJndiBeanFactoryLocator();
        }
        if (this.beanFactoryLocatorKey == null) {
            this.beanFactoryLocatorKey = BEAN_FACTORY_PATH_ENVIRONMENT_KEY;
        }
        BeanFactoryReference targetBeanFactoryRef = this.beanFactoryLocator.useBeanFactory(this.beanFactoryLocatorKey);
        ProxyFactory pf = new ProxyFactory();
        pf.addInterface(class$org$springframework$beans$factory$access$BeanFactoryReference == null ? (class$org$springframework$beans$factory$access$BeanFactoryReference = AbstractEnterpriseBean.class$("org.springframework.beans.factory.access.BeanFactoryReference")) : class$org$springframework$beans$factory$access$BeanFactoryReference);
        pf.setTarget(targetBeanFactoryRef);
        this.beanFactoryReference = (BeanFactoryReference)pf.getProxy();
        WeakReferenceMonitor.monitor(this.beanFactoryReference, new BeanFactoryReferenceReleaseListener(targetBeanFactoryRef));
    }

    void unloadBeanFactory() throws FatalBeanException {
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactoryReference.getFactory();
    }

    public void ejbRemove() {
        this.onEjbRemove();
        this.unloadBeanFactory();
    }

    protected void onEjbRemove() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeanFactoryReferenceReleaseListener
    implements WeakReferenceMonitor.ReleaseListener {
        private final BeanFactoryReference beanFactoryReference;

        public BeanFactoryReferenceReleaseListener(BeanFactoryReference beanFactoryReference) {
            this.beanFactoryReference = beanFactoryReference;
        }

        public void released() {
            this.beanFactoryReference.release();
        }
    }
}

