/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.config;

import java.util.List;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.scripting.support.ScriptFactoryPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ScriptBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME = ".scriptFactoryPostProcessor";
    private static final String SCRIPT_SOURCE_ATTRIBUTE = "script-source";
    private static final String INLINE_SCRIPT_ELEMENT = "inline-script";
    private static final String SCRIPT_INTERFACES_ATTRIBUTE = "script-interfaces";
    private static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";
    private final Class scriptFactoryClass;
    static /* synthetic */ Class class$org$springframework$scripting$ScriptFactory;
    static /* synthetic */ Class class$org$springframework$scripting$support$ScriptFactoryPostProcessor;

    public ScriptBeanDefinitionParser(Class scriptFactoryClass) {
        Assert.isAssignable(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptBeanDefinitionParser.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory, scriptFactoryClass);
        this.scriptFactoryClass = scriptFactoryClass;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String value = this.resolveScriptSource(element, parserContext.getReaderContext());
        if (value == null) {
            return null;
        }
        ScriptBeanDefinitionParser.registerScriptFactoryPostProcessorIfNecessary(parserContext.getRegistry());
        RootBeanDefinition beanDefinition = new RootBeanDefinition(this.scriptFactoryClass);
        beanDefinition.setSource(parserContext.extractSource(element));
        this.parseRefreshMetadata(element, beanDefinition);
        ConstructorArgumentValues cav = beanDefinition.getConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, value);
        if (element.hasAttribute(SCRIPT_INTERFACES_ATTRIBUTE)) {
            cav.addIndexedArgumentValue(1, element.getAttribute(SCRIPT_INTERFACES_ATTRIBUTE));
        }
        parserContext.getDelegate().parsePropertyElements(element, beanDefinition);
        return beanDefinition;
    }

    private void parseRefreshMetadata(Element element, RootBeanDefinition beanDefinition) {
        String refreshCheckDelay = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (StringUtils.hasText(refreshCheckDelay)) {
            beanDefinition.setAttribute(ScriptFactoryPostProcessor.REFRESH_CHECK_DELAY_ATTRIBUTE, new Long(refreshCheckDelay));
        }
    }

    private String resolveScriptSource(Element element, XmlReaderContext readerContext) {
        boolean hasScriptSource = element.hasAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        List elements = DomUtils.getChildElementsByTagName(element, INLINE_SCRIPT_ELEMENT);
        if (hasScriptSource && !elements.isEmpty()) {
            readerContext.error("Only one of 'script-source' and 'inline-script' should be specified.", element);
            return null;
        }
        if (hasScriptSource) {
            return element.getAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        }
        if (!elements.isEmpty()) {
            Element inlineElement = (Element)elements.get(0);
            return "inline:" + DomUtils.getTextValue(inlineElement);
        }
        readerContext.error("Must specify either 'script-source' or 'inline-script'.", element);
        return null;
    }

    private static void registerScriptFactoryPostProcessorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(class$org$springframework$scripting$support$ScriptFactoryPostProcessor == null ? (class$org$springframework$scripting$support$ScriptFactoryPostProcessor = ScriptBeanDefinitionParser.class$("org.springframework.scripting.support.ScriptFactoryPostProcessor")) : class$org$springframework$scripting$support$ScriptFactoryPostProcessor);
            registry.registerBeanDefinition(SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME, beanDefinition);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

