/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.ExecutionException;
import org.springframework.util.concurrent.FutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(final ListenableFutureCallback<? super T> callback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result) {
                try {
                    callback.onSuccess(ListenableFutureAdapter.this.adaptInternal(result));
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                }
                catch (Throwable ex) {
                    this.onFailure(ex);
                }
            }

            @Override
            public void onFailure(Throwable ex) {
                callback.onFailure(ex);
            }
        });
    }
}

