/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private final String absolutePath;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)path, "Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.absolutePath = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.clazz = null;
    }

    public ClassPathResource(String path, @Nullable Class<?> clazz) {
        Assert.notNull((Object)path, "Path must not be null");
        this.path = StringUtils.cleanPath(path);
        Object absolutePath = this.path;
        if (clazz != null && !((String)absolutePath).startsWith("/")) {
            absolutePath = ClassUtils.classPackageAsResourcePath(clazz) + "/" + (String)absolutePath;
        } else if (((String)absolutePath).startsWith("/")) {
            absolutePath = ((String)absolutePath).substring(1);
        }
        this.absolutePath = absolutePath;
        this.classLoader = null;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.absolutePath;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return this.clazz != null ? this.clazz.getClassLoader() : this.classLoader;
    }

    @Override
    public boolean exists() {
        return this.resolveURL() != null;
    }

    @Override
    public boolean isReadable() {
        URL url = this.resolveURL();
        return url != null && this.checkReadable(url);
    }

    @Nullable
    protected URL resolveURL() {
        try {
            if (this.clazz != null) {
                return this.clazz.getResource(this.path);
            }
            if (this.classLoader != null) {
                return this.classLoader.getResource(this.absolutePath);
            }
            return ClassLoader.getSystemResource(this.absolutePath);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.absolutePath) : ClassLoader.getSystemResourceAsStream(this.absolutePath));
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath(this.path, relativePath);
        return this.clazz != null ? new ClassPathResource(pathToUse, this.clazz) : new ClassPathResource(pathToUse, this.classLoader);
    }

    @Override
    @Nullable
    public String getFilename() {
        return StringUtils.getFilename(this.absolutePath);
    }

    @Override
    public String getDescription() {
        return "class path resource [" + this.absolutePath + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassPathResource)) return false;
        ClassPathResource other = (ClassPathResource)obj;
        if (!this.absolutePath.equals(other.absolutePath)) return false;
        if (!ObjectUtils.nullSafeEquals(this.getClassLoader(), other.getClassLoader())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.absolutePath.hashCode();
    }
}

