/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebRequest;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.test.web.servlet.htmlunit.WebRequestMatcher;

public final class HostRequestMatcher
implements WebRequestMatcher {
    private final Set<String> hosts = new HashSet<String>();

    public HostRequestMatcher(String ... hosts) {
        Collections.addAll(this.hosts, hosts);
    }

    @Override
    public boolean matches(WebRequest request) {
        URL url = request.getUrl();
        String host = url.getHost();
        if (this.hosts.contains(host)) {
            return true;
        }
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String hostAndPort = host + ":" + port;
        return this.hosts.contains(hostAndPort);
    }
}

