/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class CookieGenerator {
    public static final String DEFAULT_COOKIE_PATH = "/";
    @Deprecated
    public static final int DEFAULT_COOKIE_MAX_AGE = Integer.MAX_VALUE;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String cookieName;
    private String cookieDomain;
    private String cookiePath = "/";
    private Integer cookieMaxAge = null;
    private boolean cookieSecure = false;
    private boolean cookieHttpOnly = false;

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void addCookie(HttpServletResponse response, String cookieValue) {
        Assert.notNull((Object)response, (String)"HttpServletResponse must not be null");
        Cookie cookie = this.createCookie(cookieValue);
        Integer maxAge = this.getCookieMaxAge();
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        if (this.isCookieSecure()) {
            cookie.setSecure(true);
        }
        if (this.isCookieHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        response.addCookie(cookie);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added cookie with name [" + this.getCookieName() + "] and value [" + cookieValue + "]"));
        }
    }

    public void removeCookie(HttpServletResponse response) {
        Assert.notNull((Object)response, (String)"HttpServletResponse must not be null");
        Cookie cookie = this.createCookie("");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removed cookie with name [" + this.getCookieName() + "]"));
        }
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        if (this.getCookieDomain() != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setPath(this.getCookiePath());
        return cookie;
    }
}

