/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ContentCachingRequestWrapper
extends HttpServletRequestWrapper {
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String METHOD_POST = "POST";
    private final ByteArrayOutputStream cachedContent;
    private ServletInputStream inputStream;
    private BufferedReader reader;

    public ContentCachingRequestWrapper(HttpServletRequest request) {
        super(request);
        int contentLength = request.getContentLength();
        this.cachedContent = new ByteArrayOutputStream(contentLength >= 0 ? contentLength : 1024);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new ContentCachingInputStream(this.getRequest().getInputStream());
        }
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        return enc != null ? enc : "ISO-8859-1";
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public byte[] getContentAsByteArray() {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParamsToContent();
        }
        return this.cachedContent.toByteArray();
    }

    private boolean isFormPost() {
        return this.getContentType() != null && this.getContentType().contains(FORM_CONTENT_TYPE) && METHOD_POST.equalsIgnoreCase(this.getMethod());
    }

    private void writeRequestParamsToContent() {
        try {
            if (this.cachedContent.size() == 0) {
                String requestEncoding = this.getCharacterEncoding();
                Map form = this.getParameterMap();
                Iterator nameIterator = form.keySet().iterator();
                while (nameIterator.hasNext()) {
                    String name = (String)nameIterator.next();
                    List<Object> values = Arrays.asList((Object[])form.get(name));
                    Iterator<Object> valueIterator = values.iterator();
                    while (valueIterator.hasNext()) {
                        String value = (String)valueIterator.next();
                        this.cachedContent.write(URLEncoder.encode(name, requestEncoding).getBytes());
                        if (value == null) continue;
                        this.cachedContent.write(61);
                        this.cachedContent.write(URLEncoder.encode(value, requestEncoding).getBytes());
                        if (!valueIterator.hasNext()) continue;
                        this.cachedContent.write(38);
                    }
                    if (!nameIterator.hasNext()) continue;
                    this.cachedContent.write(38);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class ContentCachingInputStream
    extends ServletInputStream {
        private final ServletInputStream is;

        public ContentCachingInputStream(ServletInputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            int ch = this.is.read();
            if (ch != -1) {
                ContentCachingRequestWrapper.this.cachedContent.write(ch);
            }
            return ch;
        }
    }
}

