/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RequestParamMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (ann != null && Map.class.isAssignableFrom(parameter.getParameterType())) {
            return !StringUtils.hasText((String)ann.value());
        }
        return false;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class paramType = parameter.getParameterType();
        Map<String, String[]> parameterMap = webRequest.getParameterMap();
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            LinkedMultiValueMap result = new LinkedMultiValueMap(parameterMap.size());
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                for (String value : entry.getValue()) {
                    result.add((Object)entry.getKey(), (Object)value);
                }
            }
            return result;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            if (entry.getValue().length <= 0) continue;
            result.put(entry.getKey(), entry.getValue()[0]);
        }
        return result;
    }
}

