/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import java.util.List;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import org.springframework.http.codec.support.BaseDefaultCodecs;
import org.springframework.http.codec.support.DefaultServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class ServerDefaultCodecsImpl
extends BaseDefaultCodecs
implements ServerCodecConfigurer.ServerDefaultCodecs {
    private static final boolean synchronossMultipartPresent = ClassUtils.isPresent((String)"org.synchronoss.cloud.nio.multipart.NioMultipartParser", (ClassLoader)DefaultServerCodecConfigurer.class.getClassLoader());
    @Nullable
    private Encoder<?> sseEncoder;

    ServerDefaultCodecsImpl() {
    }

    @Override
    public void serverSentEventEncoder(Encoder<?> encoder) {
        this.sseEncoder = encoder;
    }

    @Override
    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
        if (synchronossMultipartPresent) {
            boolean enable = this.isEnableLoggingRequestDetails();
            SynchronossPartHttpMessageReader partReader = new SynchronossPartHttpMessageReader();
            partReader.setEnableLoggingRequestDetails(enable);
            typedReaders.add(partReader);
            MultipartHttpMessageReader reader = new MultipartHttpMessageReader(partReader);
            reader.setEnableLoggingRequestDetails(enable);
            typedReaders.add(reader);
        }
    }

    @Override
    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
        objectWriters.add(new ServerSentEventHttpMessageWriter(this.getSseEncoder()));
    }

    @Nullable
    private Encoder<?> getSseEncoder() {
        return this.sseEncoder != null ? this.sseEncoder : (jackson2Present ? this.getJackson2JsonEncoder() : null);
    }
}

