/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractFormController;
import org.springframework.web.util.WebUtils;

public abstract class AbstractWizardFormController
extends AbstractFormController {
    public static final String PARAM_FINISH = "_finish";
    public static final String PARAM_CANCEL = "_cancel";
    public static final String PARAM_TARGET = "_target";
    public static final String PARAM_PAGE = "_page";
    private String[] pages;
    private String pageAttribute;
    private boolean allowDirtyBack = true;
    private boolean allowDirtyForward = false;

    public AbstractWizardFormController() {
        this.setSessionForm(true);
        this.setValidateOnBinding(false);
    }

    public final void setPages(String[] pages) {
        if (pages == null || pages.length == 0) {
            throw new IllegalArgumentException("No wizard pages defined");
        }
        this.pages = pages;
    }

    public final String[] getPages() {
        return this.pages;
    }

    protected final int getPageCount() {
        return this.pages.length;
    }

    public final void setPageAttribute(String pageAttribute) {
        this.pageAttribute = pageAttribute;
    }

    public final String getPageAttribute() {
        return this.pageAttribute;
    }

    public final void setAllowDirtyBack(boolean allowDirtyBack) {
        this.allowDirtyBack = allowDirtyBack;
    }

    public final boolean isAllowDirtyBack() {
        return this.allowDirtyBack;
    }

    public final void setAllowDirtyForward(boolean allowDirtyForward) {
        this.allowDirtyForward = allowDirtyForward;
    }

    public final boolean isAllowDirtyForward() {
        return this.allowDirtyForward;
    }

    protected final void onBindAndValidate(HttpServletRequest request, Object command, BindException errors) throws Exception {
        this.onBindAndValidate(request, command, errors, this.getCurrentPage(request));
    }

    protected void onBindAndValidate(HttpServletRequest request, Object command, BindException errors, int page) throws Exception {
    }

    protected boolean isFormSubmission(HttpServletRequest request) {
        return super.isFormSubmission(request) || this.isFinishRequest(request) || this.isCancelRequest(request);
    }

    protected final Map referenceData(HttpServletRequest request, Object command, Errors errors) throws Exception {
        return this.referenceData(request, command, errors, this.getCurrentPage(request));
    }

    protected Map referenceData(HttpServletRequest request, Object command, Errors errors, int page) throws Exception {
        return this.referenceData(request, page);
    }

    protected Map referenceData(HttpServletRequest request, int page) throws Exception {
        return null;
    }

    protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors) throws Exception {
        return this.showPage(request, errors, this.getInitialPage(request, errors.getTarget()));
    }

    protected final ModelAndView showPage(HttpServletRequest request, BindException errors, int page) throws Exception {
        if (page >= 0 && page < this.getPageCount(request, errors.getTarget())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Showing wizard page " + page + " for form bean '" + this.getCommandName() + "'"));
            }
            Integer pageInteger = new Integer(page);
            String pageAttrName = this.getPageSessionAttributeName(request);
            if (this.isSessionForm()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting page session attribute [" + pageAttrName + "] to: " + pageInteger));
                }
                request.getSession().setAttribute(pageAttrName, (Object)pageInteger);
            }
            request.setAttribute(pageAttrName, (Object)pageInteger);
            HashMap<String, Integer> controlModel = new HashMap<String, Integer>();
            if (this.pageAttribute != null) {
                controlModel.put(this.pageAttribute, new Integer(page));
            }
            String viewName = this.getViewName(request, errors.getTarget(), page);
            return this.showForm(request, errors, viewName, controlModel);
        }
        throw new ServletException("Invalid wizard page number: " + page);
    }

    protected int getPageCount(HttpServletRequest request, Object command) {
        return this.getPageCount();
    }

    protected String getViewName(HttpServletRequest request, Object command, int page) {
        return this.getPages()[page];
    }

    protected int getInitialPage(HttpServletRequest request, Object command) {
        return this.getInitialPage(request);
    }

    protected int getInitialPage(HttpServletRequest request) {
        return 0;
    }

    protected String getPageSessionAttributeName(HttpServletRequest request) {
        return this.getPageSessionAttributeName();
    }

    protected String getPageSessionAttributeName() {
        return this.getClass().getName() + ".PAGE." + this.getCommandName();
    }

    protected ModelAndView handleInvalidSubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.showNewForm(request, response);
    }

    protected final ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        int currentPage = this.getCurrentPage(request);
        String pageAttrName = this.getPageSessionAttributeName(request);
        if (this.isSessionForm()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing page session attribute [" + pageAttrName + "]"));
            }
            request.getSession().removeAttribute(pageAttrName);
        }
        request.setAttribute(pageAttrName, (Object)new Integer(currentPage));
        if (this.isCancelRequest(request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancelling wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.processCancel(request, response, command, errors);
        }
        if (this.isFinishRequest(request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Finishing wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.validatePagesAndFinish(request, response, command, errors, currentPage);
        }
        if (!this.suppressValidation(request, command, errors)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Validating wizard page " + currentPage + " for form bean '" + this.getCommandName() + "'"));
            }
            this.validatePage(command, (Errors)errors, currentPage, false);
        }
        this.postProcessPage(request, command, (Errors)errors, currentPage);
        int targetPage = this.getTargetPage(request, command, (Errors)errors, currentPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Target page " + targetPage + " requested"));
        }
        if (targetPage != currentPage && (!errors.hasErrors() || this.allowDirtyBack && targetPage < currentPage || this.allowDirtyForward && targetPage > currentPage)) {
            return this.showPage(request, errors, targetPage);
        }
        return this.showPage(request, errors, currentPage);
    }

    protected int getCurrentPage(HttpServletRequest request) {
        String pageAttrName = this.getPageSessionAttributeName(request);
        Integer pageAttr = (Integer)request.getAttribute(pageAttrName);
        if (pageAttr != null) {
            return pageAttr;
        }
        String pageParam = request.getParameter(PARAM_PAGE);
        if (pageParam != null) {
            return Integer.parseInt(pageParam);
        }
        if (this.isSessionForm() && (pageAttr = (Integer)request.getSession().getAttribute(pageAttrName)) != null) {
            return pageAttr;
        }
        throw new IllegalStateException("Page attribute [" + pageAttrName + "] neither found in session nor in request");
    }

    protected boolean isFinishRequest(HttpServletRequest request) {
        return WebUtils.hasSubmitParameter((ServletRequest)request, (String)PARAM_FINISH);
    }

    protected boolean isCancelRequest(HttpServletRequest request) {
        return WebUtils.hasSubmitParameter((ServletRequest)request, (String)PARAM_CANCEL);
    }

    protected int getTargetPage(HttpServletRequest request, Object command, Errors errors, int currentPage) {
        return this.getTargetPage(request, currentPage);
    }

    protected int getTargetPage(HttpServletRequest request, int currentPage) {
        return WebUtils.getTargetPage((ServletRequest)request, (String)PARAM_TARGET, (int)currentPage);
    }

    private ModelAndView validatePagesAndFinish(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors, int currentPage) throws Exception {
        if (errors.hasErrors()) {
            return this.showPage(request, errors, currentPage);
        }
        if (!this.suppressValidation(request, command, errors)) {
            for (int page = 0; page < this.getPageCount(request, command); ++page) {
                this.validatePage(command, (Errors)errors, page, true);
                if (!errors.hasErrors()) continue;
                return this.showPage(request, errors, page);
            }
        }
        return this.processFinish(request, response, command, errors);
    }

    protected void validatePage(Object command, Errors errors, int page, boolean finish) {
        this.validatePage(command, errors, page);
    }

    protected void validatePage(Object command, Errors errors, int page) {
    }

    protected void postProcessPage(HttpServletRequest request, Object command, Errors errors, int page) throws Exception {
    }

    protected abstract ModelAndView processFinish(HttpServletRequest var1, HttpServletResponse var2, Object var3, BindException var4) throws Exception;

    protected ModelAndView processCancel(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        throw new ServletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a cancel operation");
    }
}

