/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.WebUtils;

@Deprecated
abstract class ServletAnnotationMappingUtils {
    ServletAnnotationMappingUtils() {
    }

    public static boolean checkRequestMethod(RequestMethod[] methods, HttpServletRequest request) {
        String inputMethod = request.getMethod();
        if (ObjectUtils.isEmpty((Object[])methods) && !RequestMethod.OPTIONS.name().equals(inputMethod)) {
            return true;
        }
        for (RequestMethod method : methods) {
            if (!method.name().equals(inputMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkParameters(String[] params, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])params)) {
            for (String param : params) {
                int separator = param.indexOf(61);
                if (separator == -1) {
                    if (!(param.startsWith("!") ? WebUtils.hasSubmitParameter((ServletRequest)request, (String)param.substring(1)) : !WebUtils.hasSubmitParameter((ServletRequest)request, (String)param))) continue;
                    return false;
                }
                boolean negated = separator > 0 && param.charAt(separator - 1) == '!';
                String key = !negated ? param.substring(0, separator) : param.substring(0, separator - 1);
                String value = param.substring(separator + 1);
                boolean match = value.equals(request.getParameter(key));
                if (negated) {
                    boolean bl = match = !match;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkHeaders(String[] headers, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])headers)) {
            for (String header : headers) {
                int separator = header.indexOf(61);
                if (separator == -1) {
                    if (!(header.startsWith("!") ? request.getHeader(header.substring(1)) != null : request.getHeader(header) == null)) continue;
                    return false;
                }
                boolean negated = separator > 0 && header.charAt(separator - 1) == '!';
                String key = !negated ? header.substring(0, separator) : header.substring(0, separator - 1);
                String value = header.substring(separator + 1);
                if (ServletAnnotationMappingUtils.isMediaTypeHeader(key)) {
                    List requestMediaTypes = MediaType.parseMediaTypes((String)request.getHeader(key));
                    List valueMediaTypes = MediaType.parseMediaTypes((String)value);
                    boolean found = false;
                    Iterator valIter = valueMediaTypes.iterator();
                    while (valIter.hasNext() && !found) {
                        MediaType valueMediaType = (MediaType)valIter.next();
                        Iterator reqIter = requestMediaTypes.iterator();
                        while (reqIter.hasNext() && !found) {
                            MediaType requestMediaType = (MediaType)reqIter.next();
                            if (!valueMediaType.includes(requestMediaType)) continue;
                            found = true;
                        }
                    }
                    if (negated) {
                        boolean bl = found = !found;
                    }
                    if (found) continue;
                    return false;
                }
                boolean match = value.equals(request.getHeader(key));
                if (negated) {
                    boolean bl = match = !match;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isMediaTypeHeader(String headerName) {
        return "Accept".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName);
    }
}

