/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.impl.rest.httpclient;

import com.jamesmurty.utils.XMLBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tachyon.org.jets3t.service.Constants;
import tachyon.org.jets3t.service.Jets3tProperties;
import tachyon.org.jets3t.service.ServiceException;
import tachyon.org.jets3t.service.StorageObjectsChunk;
import tachyon.org.jets3t.service.StorageService;
import tachyon.org.jets3t.service.acl.AccessControlList;
import tachyon.org.jets3t.service.impl.rest.HttpException;
import tachyon.org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import tachyon.org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import tachyon.org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import tachyon.org.jets3t.service.impl.rest.httpclient.HttpMethodAndByteCount;
import tachyon.org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import tachyon.org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import tachyon.org.jets3t.service.model.CreateBucketConfiguration;
import tachyon.org.jets3t.service.model.S3Bucket;
import tachyon.org.jets3t.service.model.S3Object;
import tachyon.org.jets3t.service.model.StorageBucket;
import tachyon.org.jets3t.service.model.StorageObject;
import tachyon.org.jets3t.service.model.StorageOwner;
import tachyon.org.jets3t.service.mx.MxDelegate;
import tachyon.org.jets3t.service.security.ProviderCredentials;
import tachyon.org.jets3t.service.utils.RestUtils;
import tachyon.org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestStorageService
extends StorageService
implements AWSRequestAuthorizer {
    private static final Log log = LogFactory.getLog(RestStorageService.class);
    protected HttpClient httpClient = null;
    protected HttpConnectionManager connectionManager = null;
    protected CredentialsProvider credentialsProvider = null;
    protected String defaultStorageClass = null;

    public RestStorageService(ProviderCredentials credentials) {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public RestStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) {
        this(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public RestStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) {
        super(credentials, invokingApplicationDescription, jets3tProperties);
        this.credentialsProvider = credentialsProvider;
        HttpClientAndConnectionManager initHttpResult = this.initHttpConnection(hostConfig);
        this.httpClient = initHttpResult.getHttpClient();
        this.connectionManager = initHttpResult.getHttpConnectionManager();
        this.defaultStorageClass = this.jets3tProperties.getStringProperty("s3service.default-storage-class", null);
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, this.getEndpoint());
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, this.getEndpoint());
        }
    }

    protected abstract boolean isTargettingGoogleStorageService();

    @Override
    protected void shutdownImpl() throws ServiceException {
        HttpConnectionManager manager = this.getHttpConnectionManager();
        if (manager instanceof SimpleHttpConnectionManager) {
            ((SimpleHttpConnectionManager)manager).shutdown();
        } else if (manager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)manager).shutdown();
        } else {
            manager.closeIdleConnections(0L);
        }
    }

    protected HttpClientAndConnectionManager initHttpConnection(HostConfiguration hostConfig) {
        HttpClientAndConnectionManager manager = RestUtils.initHttpConnection(this, hostConfig, this.jets3tProperties, this.getInvokingApplicationDescription(), this.credentialsProvider);
        if (this.isTargettingGoogleStorageService()) {
            manager.getHttpClient().getParams().setBooleanParameter("http.protocol.expect-continue", false);
        }
        return manager;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.connectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.connectionManager = httpConnectionManager;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected boolean isXmlContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("application/xml".toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRequest(HttpMethodBase httpMethod, int[] expectedResponseCodes) throws ServiceException {
        try {
            byte[] responseBody;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing " + httpMethod.getName() + " request for '" + httpMethod.getURI().toString() + "', expecting response codes: " + "[" + ServiceUtils.join(expectedResponseCodes, ",") + "]"));
            }
            boolean completedWithoutRecoverableError = true;
            int internalErrorCount = 0;
            int requestTimeoutErrorCount = 0;
            int redirectCount = 0;
            boolean wasRecentlyRedirected = false;
            int responseCode = -1;
            do {
                if (!wasRecentlyRedirected) {
                    this.authorizeHttpRequest((HttpMethod)httpMethod);
                } else {
                    wasRecentlyRedirected = false;
                }
                responseCode = this.httpClient.executeMethod((HttpMethod)httpMethod);
                if (responseCode == 307) {
                    this.authorizeHttpRequest((HttpMethod)httpMethod);
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    httpMethod.setURI(new URI(locationHeader.getValue(), true));
                    completedWithoutRecoverableError = false;
                    wasRecentlyRedirected = true;
                    if (++redirectCount > 5) {
                        throw new ServiceException("Exceeded 307 redirect limit (5).");
                    }
                } else if (responseCode == 500 || responseCode == 503) {
                    completedWithoutRecoverableError = false;
                    this.sleepOnInternalError(++internalErrorCount);
                } else {
                    completedWithoutRecoverableError = true;
                }
                String contentType = "";
                if (httpMethod.getResponseHeader("Content-Type") != null) {
                    contentType = httpMethod.getResponseHeader("Content-Type").getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response for '" + httpMethod.getPath() + "'. Content-Type: " + contentType + ", Headers: " + Arrays.asList(httpMethod.getResponseHeaders())));
                }
                boolean didReceiveExpectedResponseCode = false;
                for (int i = 0; i < expectedResponseCodes.length && !didReceiveExpectedResponseCode; ++i) {
                    if (responseCode != expectedResponseCodes[i]) continue;
                    didReceiveExpectedResponseCode = true;
                }
                if (didReceiveExpectedResponseCode) continue;
                if (log.isWarnEnabled()) {
                    String requestDescription = httpMethod.getName() + " '" + httpMethod.getPath() + (httpMethod.getQueryString() != null && httpMethod.getQueryString().length() > 0 ? "?" + httpMethod.getQueryString() : "") + "'" + " -- ResponseCode: " + httpMethod.getStatusCode() + ", ResponseStatus: " + httpMethod.getStatusText() + ", Request Headers: [" + ServiceUtils.join(httpMethod.getRequestHeaders(), ", ") + "]" + ", Response Headers: [" + ServiceUtils.join(httpMethod.getResponseHeaders(), ", ") + "]";
                    requestDescription = requestDescription.replaceAll("[\\n\\r\\f]", "");
                    log.warn((Object)("Error Response: " + requestDescription));
                }
                if (this.isXmlContentType(contentType) && httpMethod.getResponseBodyAsStream() != null && httpMethod.getResponseContentLength() != 0L) {
                    StringBuffer sb;
                    block38: {
                        Object var15_23;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Response '" + httpMethod.getPath() + "' - Received error response with XML message"));
                        }
                        sb = new StringBuffer();
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                sb.append(line + "\n");
                            }
                            var15_23 = null;
                            if (reader == null) break block38;
                        }
                        catch (Throwable throwable) {
                            var15_23 = null;
                            if (reader == null) throw throwable;
                            reader.close();
                            throw throwable;
                        }
                        reader.close();
                    }
                    httpMethod.releaseConnection();
                    ServiceException exception = new ServiceException("S3 Error Message.", sb.toString());
                    exception.setResponseHeaders(RestUtils.convertHeadersToMap(httpMethod.getResponseHeaders()));
                    if ("RequestTimeout".equals(exception.getErrorCode())) {
                        int retryMaxCount = this.jets3tProperties.getIntProperty("httpclient.retry-max", 5);
                        if (requestTimeoutErrorCount >= retryMaxCount) {
                            if (!log.isErrorEnabled()) throw exception;
                            log.error((Object)("Exceeded maximum number of retries for RequestTimeout errors: " + retryMaxCount));
                            throw exception;
                        }
                        ++requestTimeoutErrorCount;
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Retrying connection that failed with RequestTimeout error, attempt number " + requestTimeoutErrorCount + " of " + retryMaxCount));
                        }
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    if ("RequestTimeTooSkewed".equals(exception.getErrorCode())) {
                        this.timeOffset = RestUtils.getAWSTimeAdjustment();
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and S3 server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection."));
                        }
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    if (responseCode == 500 || responseCode == 503) continue;
                    if (responseCode == 307) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Following Temporary Redirect to: " + httpMethod.getURI().toString()));
                        continue;
                    }
                    if (responseCode != 404) throw exception;
                    if (!"PUT".equalsIgnoreCase(httpMethod.getName())) throw exception;
                    if (!"NoSuchKey".equals(exception.getErrorCode())) throw exception;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring NoSuchKey/404 error on PUT to: " + httpMethod.getURI().toString()));
                    continue;
                }
                String responseText = null;
                byte[] responseBody2 = httpMethod.getResponseBody();
                if (responseBody2 != null && responseBody2.length > 0) {
                    responseText = new String(responseBody2);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing error response without XML content");
                }
                httpMethod.releaseConnection();
                if (responseCode == 500 || responseCode == 503) continue;
                HttpException httpException = new HttpException(httpMethod.getStatusCode(), httpMethod.getStatusText());
                ServiceException exception = new ServiceException("Request Error" + (responseText != null ? " [" + responseText + "]." : "."), httpException);
                exception.setResponseHeaders(RestUtils.convertHeadersToMap(httpMethod.getResponseHeaders()));
                throw exception;
            } while (!completedWithoutRecoverableError);
            if (httpMethod.getResponseBodyAsStream() != null) {
                if (httpMethod.getResponseBodyAsStream().available() != 0) return;
            }
            if (httpMethod.getResponseContentLength() != 0L) return;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing response without content");
            }
            if ((responseBody = httpMethod.getResponseBody()) != null && responseBody.length > 0) {
                throw new ServiceException("Oops, too keen to release connection with a non-empty response body");
            }
            httpMethod.releaseConnection();
            return;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing HttpClient connection after error: " + t.getMessage()));
            }
            httpMethod.releaseConnection();
            ServiceException serviceException = null;
            if (t instanceof ServiceException) {
                serviceException = (ServiceException)t;
            } else {
                MxDelegate.getInstance().registerS3ServiceExceptionEvent();
                serviceException = new ServiceException("Request Error: " + t, t);
            }
            if (!serviceException.isParsedFromXmlMessage() && httpMethod.getResponseHeader("x-amz-request-id") != null && httpMethod.getResponseHeader("x-amz-id-2") != null) {
                serviceException.setRequestAndHostIds(httpMethod.getResponseHeader("x-amz-request-id").getValue(), httpMethod.getResponseHeader("x-amz-id-2").getValue());
            }
            serviceException.setRequestVerb(httpMethod.getName());
            serviceException.setRequestPath(httpMethod.getPath());
            try {
                serviceException.setResponseCode(httpMethod.getStatusCode());
                serviceException.setResponseStatus(httpMethod.getStatusText());
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (httpMethod.getRequestHeader("Host") != null) {
                serviceException.setRequestHost(httpMethod.getRequestHeader("Host").getValue());
            }
            if (httpMethod.getResponseHeader("Date") == null) throw serviceException;
            serviceException.setResponseDate(httpMethod.getResponseHeader("Date").getValue());
            throw serviceException;
        }
    }

    @Override
    public void authorizeHttpRequest(HttpMethod httpMethod) throws Exception {
        String queryString;
        String hostname;
        block9: {
            if (this.getProviderCredentials() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding authorization for Access Key '" + this.getProviderCredentials().getAccessKey() + "'."));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Service has no Credential and is un-authenticated, skipping authorization");
                }
                return;
            }
            hostname = null;
            try {
                hostname = httpMethod.getURI().getHost();
            }
            catch (URIException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Unable to determine hostname target for request", (Throwable)e);
            }
        }
        String fullUrl = httpMethod.getPath();
        String s3Endpoint = this.getEndpoint();
        if (!s3Endpoint.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + s3Endpoint);
            fullUrl = subdomainOffset > 0 ? "/" + hostname.substring(0, subdomainOffset) + httpMethod.getPath() : "/" + hostname + httpMethod.getPath();
        }
        if ((queryString = httpMethod.getQueryString()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        String canonicalString = RestUtils.makeServiceCanonicalString(httpMethod.getName(), fullUrl, this.convertHeadersToMap(httpMethod.getRequestHeaders()), null, this.getRestHeaderPrefix(), this.getResourceParameterNames());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Canonical string ('|' is a newline): " + canonicalString.replace('\n', '|')));
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.getProviderCredentials().getSecretKey(), canonicalString);
        String authorizationString = this.getSignatureIdentifier() + " " + this.getProviderCredentials().getAccessKey() + ":" + signedCanonical;
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map<String, String> requestParameters) throws ServiceException {
        if (requestParameters != null) {
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                urlPath = urlPath + (urlPath.indexOf("?") < 0 ? "?" : "&") + RestUtils.encodeUrlString(key);
                if (value != null && value.length() > 0) {
                    urlPath = urlPath + "=" + RestUtils.encodeUrlString(value);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Added request parameter: " + key + "=" + value));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request parameter without value: " + key));
            }
        }
        return urlPath;
    }

    protected void addRequestHeadersToConnection(HttpMethodBase httpMethod, Map<String, Object> requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry<String, Object> entry : requestHeaders.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                httpMethod.setRequestHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request header to connection: " + key + "=" + value));
            }
        }
    }

    private Map<String, Object> convertHeadersToMap(Header[] headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; headers != null && i < headers.length; ++i) {
            map.put(headers[i].getName(), headers[i].getValue());
        }
        return map;
    }

    protected void addMetadataToHeaders(HttpMethodBase httpMethod, Map<String, Object> metadata) throws ServiceException {
        HashMap<String, String> headersAlreadySeenMap = new HashMap<String, String>(metadata.size());
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object objValue = entry.getValue();
            if (key == null) continue;
            String value = objValue.toString();
            boolean validAscii = false;
            UnsupportedEncodingException encodingException = null;
            try {
                byte[] asciiBytes = key.getBytes("ASCII");
                byte[] utf8Bytes = key.getBytes("UTF-8");
                validAscii = Arrays.equals(asciiBytes, utf8Bytes);
            }
            catch (UnsupportedEncodingException e) {
                encodingException = e;
            }
            if (!validAscii) {
                String message = "User metadata name is incompatible with the S3 REST interface, only ASCII characters are allowed in HTTP headers: " + key;
                if (encodingException == null) {
                    throw new ServiceException(message);
                }
                throw new ServiceException(message, encodingException);
            }
            if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0) {
                throw new ServiceException("The value of metadata item " + key + " cannot be represented as an HTTP header for the REST S3 interface: " + value);
            }
            String duplicateValue = (String)headersAlreadySeenMap.get(key.toLowerCase());
            if (duplicateValue != null && !duplicateValue.equals(value)) {
                throw new ServiceException("HTTP header name occurs multiple times in request with different values, probably due to mismatched capitalization when setting metadata names. Duplicate metadata name: '" + key + "', All metadata: " + metadata);
            }
            httpMethod.setRequestHeader(key, value);
            headersAlreadySeenMap.put(key.toLowerCase(), value);
        }
    }

    protected void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
        if (!expectedETag.equals(uploadedObject.getETag())) {
            throw new ServiceException("Mismatch between MD5 hash of uploaded data (" + expectedETag + ") and ETag returned by S3 (" + uploadedObject.getETag() + ") for object key: " + uploadedObject.getKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned by S3: " + uploadedObject.getKey()));
        }
    }

    protected HttpMethodBase performRestHead(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders) throws ServiceException {
        HttpMethodBase httpMethod = this.setupConnection(HTTP_METHOD.HEAD, bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        this.performRequest(httpMethod, new int[]{200});
        return httpMethod;
    }

    protected HttpMethodBase performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders) throws ServiceException {
        HttpMethodBase httpMethod = this.setupConnection(HTTP_METHOD.GET, bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        int[] expectedStatusCodes = new int[]{200};
        if (requestHeaders != null && requestHeaders.containsKey("Range")) {
            expectedStatusCodes = new int[]{206, 200};
        }
        this.performRequest(httpMethod, expectedStatusCodes);
        return httpMethod;
    }

    protected HttpMethodAndByteCount performRestPut(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, RequestEntity requestEntity, boolean autoRelease) throws ServiceException {
        HttpMethodBase httpMethod = this.setupConnection(HTTP_METHOD.PUT, bucketName, objectKey, requestParameters);
        Map<String, Object> renamedMetadata = this.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(httpMethod, renamedMetadata);
        long contentLength = 0L;
        if (requestEntity != null) {
            ((PutMethod)httpMethod).setRequestEntity(requestEntity);
        } else {
            httpMethod.setRequestHeader("Content-Length", "0");
        }
        this.performRequest(httpMethod, new int[]{200, 204});
        if (requestEntity != null) {
            contentLength = ((PutMethod)httpMethod).getRequestEntity().getContentLength();
        }
        if (autoRelease) {
            httpMethod.releaseConnection();
        }
        return new HttpMethodAndByteCount(httpMethod, contentLength);
    }

    protected PostMethod performRestPost(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, RequestEntity requestEntity, boolean autoRelease) throws ServiceException {
        HttpMethodBase postMethod = this.setupConnection(HTTP_METHOD.POST, bucketName, objectKey, requestParameters);
        Map<String, Object> renamedMetadata = this.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(postMethod, renamedMetadata);
        if (requestEntity != null) {
            ((PostMethod)postMethod).setRequestEntity(requestEntity);
        }
        this.performRequest(postMethod, new int[]{200});
        if (autoRelease) {
            postMethod.releaseConnection();
        }
        return (PostMethod)postMethod;
    }

    protected HttpMethodBase performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, String multiFactorSerialNumber, String multiFactorAuthCode) throws ServiceException {
        HttpMethodBase httpMethod = this.setupConnection(HTTP_METHOD.DELETE, bucketName, objectKey, requestParameters);
        if (multiFactorSerialNumber != null || multiFactorAuthCode != null) {
            httpMethod.setRequestHeader("x-amz-mfa", multiFactorSerialNumber + " " + multiFactorAuthCode);
        }
        this.performRequest(httpMethod, new int[]{204, 200});
        if (log.isDebugEnabled()) {
            log.debug((Object)"Releasing HttpMethod after delete");
        }
        httpMethod.releaseConnection();
        return httpMethod;
    }

    protected HttpMethodAndByteCount performRestPutWithXmlBuilder(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, XMLBuilder builder) throws ServiceException {
        try {
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            if (!metadata.containsKey("content-type")) {
                metadata.put("Content-Type", "text/plain");
            }
            String xml = builder.asString(null);
            return this.performRestPut(bucketName, objectKey, metadata, requestParameters, (RequestEntity)new StringRequestEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException("Failed to PUT request containing an XML document", e);
        }
    }

    protected HttpMethodBase performRestPostWithXmlBuilder(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, XMLBuilder builder) throws ServiceException {
        try {
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            if (!metadata.containsKey("content-type")) {
                metadata.put("Content-Type", "text/plain");
            }
            String xml = builder.asString(null);
            return this.performRestPost(bucketName, objectKey, metadata, requestParameters, (RequestEntity)new StringRequestEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), false);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException("Failed to POST request containing an XML document", e);
        }
    }

    protected HttpMethodBase setupConnection(HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws ServiceException {
        if (bucketName == null) {
            throw new ServiceException("Cannot connect to S3 Service with a null path");
        }
        boolean disableDnsBuckets = this.getDisableDnsBuckets();
        String s3Endpoint = this.getEndpoint();
        String hostname = ServiceUtils.generateS3HostnameForBucket(bucketName, disableDnsBuckets, s3Endpoint);
        String virtualPath = this.getVirtualPath();
        String resourceString = "/";
        if (hostname.equals(s3Endpoint) && bucketName.length() > 0) {
            resourceString = resourceString + bucketName + "/";
        }
        resourceString = resourceString + (objectKey != null ? RestUtils.encodeUrlString(objectKey) : "");
        String url = null;
        if (this.isHttpsOnly()) {
            int securePort = this.getHttpsPort();
            url = "https://" + hostname + ":" + securePort + virtualPath + resourceString;
        } else {
            int insecurePort = this.getHttpPort();
            url = "http://" + hostname + ":" + insecurePort + virtualPath + resourceString;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("S3 URL: " + url));
        }
        url = this.addRequestParametersToUrlPath(url, requestParameters);
        PutMethod httpMethod = null;
        if (HTTP_METHOD.PUT.equals((Object)method)) {
            httpMethod = new PutMethod(url);
        } else if (HTTP_METHOD.POST.equals((Object)method)) {
            httpMethod = new PostMethod(url);
        } else if (HTTP_METHOD.HEAD.equals((Object)method)) {
            httpMethod = new HeadMethod(url);
        } else if (HTTP_METHOD.GET.equals((Object)method)) {
            httpMethod = new GetMethod(url);
        } else if (HTTP_METHOD.DELETE.equals((Object)method)) {
            httpMethod = new DeleteMethod(url);
        } else {
            throw new IllegalArgumentException("Unrecognised HTTP method name: " + (Object)((Object)method));
        }
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        if (httpMethod.getRequestHeader("Content-Type") == null) {
            httpMethod.setRequestHeader("Content-Type", "");
        }
        return httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isBucketAccessible(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking existence of bucket: " + bucketName));
        }
        HttpMethodBase httpMethod = null;
        try {
            block12: {
                try {
                    httpMethod = this.performRestHead(bucketName, null, null, null);
                    if (httpMethod.getResponseBodyAsStream() == null) break block12;
                    httpMethod.getResponseBodyAsStream().close();
                }
                catch (ServiceException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                    }
                    boolean bl = false;
                    Object var6_4 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return bl;
                    httpMethod.releaseConnection();
                    return bl;
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                    }
                    Object var6_5 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return true;
                    httpMethod.releaseConnection();
                    return true;
                }
            }
            Object var6_3 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) return true;
            httpMethod.releaseConnection();
            return true;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) throw throwable;
            httpMethod.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkBucketStatus(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking availability of bucket name: " + bucketName));
        }
        HttpMethodBase httpMethod = null;
        try {
            block15: {
                try {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("max-keys", "0");
                    httpMethod = this.performRestHead(bucketName, null, params, null);
                    if (httpMethod.getResponseBodyAsStream() == null) break block15;
                    httpMethod.getResponseBodyAsStream().close();
                }
                catch (ServiceException e) {
                    if (e.getResponseCode() == 403) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Bucket named '" + bucketName + "' exists but is inaccessible, " + "probably belongs to another user"));
                        }
                        int n = 2;
                        Object var6_7 = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Releasing un-wanted bucket HEAD response");
                        }
                        if (httpMethod == null) return n;
                        httpMethod.releaseConnection();
                        return n;
                    }
                    if (e.getResponseCode() != 404) throw e;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                    }
                    int n = 1;
                    Object var6_8 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return n;
                    httpMethod.releaseConnection();
                    return n;
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                    }
                    Object var6_9 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return 0;
                    httpMethod.releaseConnection();
                    return 0;
                }
            }
            Object var6_6 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) return 0;
            httpMethod.releaseConnection();
            return 0;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) throw throwable;
            httpMethod.releaseConnection();
            throw throwable;
        }
    }

    @Override
    protected StorageBucket[] listAllBucketsImpl() throws ServiceException {
        String bucketName;
        HttpMethodBase httpMethod;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing all buckets for user: " + this.getProviderCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpMethod = this.performRestGet(bucketName = "", null, null, null)).getResponseHeader("Content-Type").getValue())) {
            throw new ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        StorageBucket[] buckets = this.getXmlResponseSaxParser().parseListMyBucketsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getBuckets();
        return buckets;
    }

    @Override
    protected StorageOwner getAccountOwnerImpl() throws ServiceException {
        String bucketName;
        HttpMethodBase httpMethod;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up owner of S3 account via the ListAllBuckets response: " + this.getProviderCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpMethod = this.performRestGet(bucketName = "", null, null, null)).getResponseHeader("Content-Type").getValue())) {
            throw new ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        StorageOwner owner = this.getXmlResponseSaxParser().parseListMyBucketsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getOwner();
        return owner;
    }

    @Override
    protected StorageObject[] listObjectsImpl(String bucketName, String prefix, String delimiter, long maxListingLength) throws ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, null, null).getObjects();
    }

    @Override
    protected StorageObjectsChunk listObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey, null);
    }

    protected StorageObjectsChunk listObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String priorLastKey, String priorLastVersion) throws ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<StorageObject> objects = new ArrayList<StorageObject>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            if (priorLastKey != null) {
                parameters.put("marker", priorLastKey);
            } else {
                parameters.remove("marker");
            }
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, parameters, null);
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler = null;
            try {
                listBucketHandler = this.getXmlResponseSaxParser().parseListBucketResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException e) {
                if (e.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)e);
                    continue;
                }
                throw e;
            }
            StorageObject[] partialObjects = listBucketHandler.getObjects();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialObjects.length + " objects in one batch"));
            }
            objects.addAll(Arrays.asList(partialObjects));
            String[] partialCommonPrefixes = listBucketHandler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = listBucketHandler.isListingTruncated();
            if (incompleteListing) {
                priorLastKey = listBucketHandler.getMarkerForNextListing();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Yet to receive complete listing of bucket contents, last key for prior chunk: " + priorLastKey));
                }
            } else {
                priorLastKey = null;
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + objects.size() + " objects in total"));
            }
            return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null);
        }
        return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), priorLastKey);
    }

    @Override
    protected void deleteObjectImpl(String bucketName, String objectKey, String versionId, String multiFactorSerialNumber, String multiFactorAuthCode) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        this.performRestDelete(bucketName, objectKey, requestParameters, multiFactorSerialNumber, multiFactorAuthCode);
    }

    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    @Override
    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey, String versionId) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving versioned Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HttpMethodBase httpMethod = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    @Override
    protected AccessControlList getBucketAclImpl(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    @Override
    protected void putObjectAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ServiceException {
        this.putAclImpl(bucketName, objectKey, acl, versionId);
    }

    @Override
    protected void putBucketAclImpl(String bucketName, AccessControlList acl) throws ServiceException {
        String fullKey = bucketName;
        this.putAclImpl(fullKey, null, acl, null);
    }

    protected void putAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            String aclAsXml = acl.toXml();
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, (RequestEntity)new StringRequestEntity(aclAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to encode ACL XML document", e);
        }
    }

    @Override
    protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating bucket with name: " + bucketName));
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        StringRequestEntity requestEntity = null;
        if (location != null && !"US".equalsIgnoreCase(location)) {
            metadata.put("Content-Type", "text/xml");
            try {
                CreateBucketConfiguration config = new CreateBucketConfiguration(location);
                String configXml = config.toXml();
                metadata.put("Content-Length", String.valueOf(configXml.length()));
                requestEntity = new StringRequestEntity(configXml, "text/xml", Constants.DEFAULT_ENCODING);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to encode CreateBucketConfiguration XML document", e);
            }
        }
        Map<String, Object> map = this.createObjectImpl(bucketName, null, null, (RequestEntity)requestEntity, (Map<String, Object>)metadata, null, acl, null);
        StorageBucket bucket = this.newBucket();
        bucket.setName(bucketName);
        if (bucket instanceof S3Bucket) {
            ((S3Bucket)bucket).setLocation(location);
        }
        bucket.setAcl(acl);
        bucket.replaceAllMetadata(map);
        return bucket;
    }

    @Override
    protected void deleteBucketImpl(String bucketName) throws ServiceException {
        this.performRestDelete(bucketName, null, null, null, null);
    }

    @Override
    protected StorageObject putObjectImpl(String bucketName, StorageObject object) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Object with key " + object.getKey() + " in bucket " + bucketName));
        }
        boolean isLiveMD5HashingRequired = object.getMetadata("Content-MD5") == null;
        Object requestEntity = null;
        if (object.getDataInputStream() != null) {
            if (object.containsMetadata("Content-Length")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Uploading object data with Content-Length: " + object.getContentLength()));
                }
                requestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Content-Length of data stream not set, will automatically determine data length in memory");
                }
                requestEntity = new InputStreamRequestEntity(object.getDataInputStream(), -2L);
            }
        }
        this.putObjectWithRequestEntityImpl(bucketName, object, (RequestEntity)requestEntity, null);
        return object;
    }

    protected void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, RequestEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
        Map<String, Object> map;
        boolean isLiveMD5HashingRequired;
        block3: {
            isLiveMD5HashingRequired = object.getMetadata("Content-MD5") == null;
            map = this.createObjectImpl(bucketName, object.getKey(), object.getContentType(), requestEntity, object.getMetadataMap(), requestParams, object.getAcl(), object.getStorageClass());
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        object.replaceAllMetadata(map);
        if (isLiveMD5HashingRequired && requestEntity instanceof RepeatableRequestEntity) {
            String hexMD5OfUploadedData = ServiceUtils.toHex(((RepeatableRequestEntity)requestEntity).getMD5DigestOfData());
            this.verifyExpectedAndActualETagValues(hexMD5OfUploadedData, object);
        }
    }

    protected Map<String, Object> createObjectImpl(String bucketName, String objectKey, String contentType, RequestEntity requestEntity, Map<String, Object> metadata, Map<String, String> requestParams, AccessControlList acl, String storageClass) throws ServiceException {
        boolean isExtraAclPutRequired;
        metadata = metadata == null ? new HashMap<String, Object>() : new HashMap<String, Object>(metadata);
        if (contentType != null) {
            metadata.put("Content-Type", contentType);
        } else {
            metadata.put("Content-Type", "application/octet-stream");
        }
        if (requestParams == null || !requestParams.containsKey("uploadId")) {
            this.prepareStorageClass(metadata, storageClass, objectKey);
        }
        boolean bl = isExtraAclPutRequired = !this.prepareCannedAcl(metadata, acl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating object bucketName=" + bucketName + ", objectKey=" + objectKey + ", storageClass=" + storageClass + "." + " Content-Type=" + metadata.get("Content-Type") + " Including data? " + (requestEntity != null) + " Metadata: " + metadata + " ACL: " + acl));
        }
        HttpMethodAndByteCount methodAndByteCount = this.performRestPut(bucketName, objectKey, metadata, requestParams, requestEntity, true);
        HttpMethodBase httpMethod = methodAndByteCount.getHttpMethod();
        Map<String, Object> map = new HashMap<String, Object>();
        map.putAll(metadata);
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        map.put("Content-Length", String.valueOf(methodAndByteCount.getByteCount()));
        map = ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix());
        if (isExtraAclPutRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(bucketName, objectKey, acl, null);
        }
        return map;
    }

    protected boolean prepareCannedAcl(Map<String, Object> metadata, AccessControlList acl) {
        if (acl != null) {
            if (metadata == null) {
                throw new IllegalArgumentException("Null metadata not allowed.");
            }
            String restHeaderAclValue = acl.getValueForRESTHeaderACL();
            if (restHeaderAclValue != null) {
                metadata.put(this.getRestHeaderPrefix() + "acl", restHeaderAclValue);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void prepareStorageClass(Map<String, Object> metadata, String storageClass, String objectKey) {
        if (this.getEnableStorageClasses()) {
            if (metadata == null) {
                throw new IllegalArgumentException("Null metadata not allowed.");
            }
            if (storageClass == null && this.defaultStorageClass != null) {
                storageClass = this.defaultStorageClass;
                log.debug((Object)("Applied default storage class '" + storageClass + "' to object '" + objectKey + "'"));
            }
            if (storageClass != null) {
                metadata.put(this.getRestHeaderPrefix() + "storage-class", storageClass);
            }
        }
    }

    @Override
    protected Map<String, Object> copyObjectImpl(String sourceBucketName, String sourceObjectKey, String destinationBucketName, String destinationObjectKey, AccessControlList acl, Map<String, Object> destinationMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, String versionId, String destinationObjectStorageClass) throws ServiceException {
        String tags;
        boolean isExtraAclPutRequired;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying Object from " + sourceBucketName + ":" + sourceObjectKey + " to " + destinationBucketName + ":" + destinationObjectKey));
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        String sourceKey = RestUtils.encodeUrlString(sourceBucketName + "/" + sourceObjectKey);
        if (versionId != null) {
            sourceKey = sourceKey + "?versionId=" + versionId;
        }
        metadata.put(this.getRestHeaderPrefix() + "copy-source", sourceKey);
        if (destinationObjectStorageClass != null) {
            this.prepareStorageClass(metadata, destinationObjectStorageClass, destinationObjectKey);
        }
        if (destinationMetadata != null) {
            metadata.put(this.getRestHeaderPrefix() + "metadata-directive", "REPLACE");
            metadata.putAll(destinationMetadata);
            if (!metadata.containsKey("Content-Type")) {
                metadata.put("Content-Type", "application/octet-stream");
            }
        } else {
            metadata.put(this.getRestHeaderPrefix() + "metadata-directive", "COPY");
        }
        boolean bl = isExtraAclPutRequired = !this.prepareCannedAcl(metadata, acl);
        if (ifModifiedSince != null) {
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-modified-since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-unmodified-since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-none-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-none-match:" + tags));
            }
        }
        HttpMethodAndByteCount methodAndByteCount = this.performRestPut(destinationBucketName, destinationObjectKey, metadata, null, null, false);
        XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parseCopyObjectResponse(new HttpMethodReleaseInputStream((HttpMethod)methodAndByteCount.getHttpMethod()));
        methodAndByteCount.getHttpMethod().releaseConnection();
        if (handler.isErrorResponse()) {
            throw new ServiceException("Copy failed: Code=" + handler.getErrorCode() + ", Message=" + handler.getErrorMessage() + ", RequestId=" + handler.getErrorRequestId() + ", HostId=" + handler.getErrorHostId());
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("Last-Modified", handler.getLastModified());
        map.put("ETag", handler.getETag());
        map.putAll(this.convertHeadersToMap(methodAndByteCount.getHttpMethod().getResponseHeaders()));
        map = ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix());
        if (isExtraAclPutRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(destinationBucketName, destinationObjectKey, acl, null);
        }
        return map;
    }

    @Override
    protected StorageObject getObjectDetailsImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, String versionId) throws ServiceException {
        return this.getObjectImpl(true, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, null, versionId);
    }

    @Override
    protected StorageObject getObjectImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws ServiceException {
        return this.getObjectImpl(false, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId);
    }

    private StorageObject getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws ServiceException {
        String tags;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving " + (headOnly ? "Head" : "All") + " information for bucket " + bucketName + " and object " + objectKey));
        }
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (ifModifiedSince != null) {
            requestHeaders.put("If-Modified-Since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            requestHeaders.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            requestHeaders.put("If-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            requestHeaders.put("If-None-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-none-match:" + tags));
            }
        }
        if (byteRangeStart != null || byteRangeEnd != null) {
            String range = "bytes=" + (byteRangeStart != null ? byteRangeStart.toString() : "") + "-" + (byteRangeEnd != null ? byteRangeEnd.toString() : "");
            requestHeaders.put("Range", range);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if it is within range:" + range));
            }
        }
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HttpMethodBase httpMethod = null;
        httpMethod = headOnly ? this.performRestHead(bucketName, objectKey, requestParameters, requestHeaders) : this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        StorageObject responseObject = this.newObject();
        responseObject.setKey(objectKey);
        responseObject.setBucketName(bucketName);
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    public S3Object putObjectWithSignedUrl(String signedPutUrl, S3Object object) throws ServiceException {
        String s3Endpoint;
        boolean isLiveMD5HashingRequired;
        RepeatableRequestEntity repeatableRequestEntity;
        PutMethod putMethod;
        block8: {
            putMethod = new PutMethod(signedPutUrl);
            Map<String, Object> renamedMetadata = this.renameMetadataKeys(object.getMetadataMap());
            this.addMetadataToHeaders((HttpMethodBase)putMethod, renamedMetadata);
            if (!object.containsMetadata("Content-Length")) {
                throw new IllegalStateException("Content-Length must be specified for objects put using signed PUT URLs");
            }
            repeatableRequestEntity = null;
            isLiveMD5HashingRequired = object.getMetadata("Content-MD5") == null;
            s3Endpoint = this.getEndpoint();
            if (object.getDataInputStream() != null) {
                repeatableRequestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
                putMethod.setRequestEntity((RequestEntity)repeatableRequestEntity);
            }
            this.performRequest((HttpMethodBase)putMethod, new int[]{200});
            putMethod.releaseConnection();
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        try {
            S3Object uploadedObject = ServiceUtils.buildObjectFromUrl(putMethod.getURI().getHost(), putMethod.getPath(), s3Endpoint);
            uploadedObject.setBucketName(uploadedObject.getBucketName());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(this.convertHeadersToMap(putMethod.getResponseHeaders()));
            uploadedObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
            if (repeatableRequestEntity != null && isLiveMD5HashingRequired) {
                String hexMD5OfUploadedData = ServiceUtils.toHex(repeatableRequestEntity.getMD5DigestOfData());
                this.verifyExpectedAndActualETagValues(hexMD5OfUploadedData, uploadedObject);
            }
            return uploadedObject;
        }
        catch (URIException e) {
            throw new ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to determine name of object created with signed PUT", e);
        }
    }

    public void deleteObjectWithSignedUrl(String signedDeleteUrl) throws ServiceException {
        DeleteMethod deleteMethod = new DeleteMethod(signedDeleteUrl);
        this.performRequest((HttpMethodBase)deleteMethod, new int[]{204, 200});
        deleteMethod.releaseConnection();
    }

    public S3Object getObjectWithSignedUrl(String signedGetUrl) throws ServiceException {
        return this.getObjectWithSignedUrlImpl(signedGetUrl, false);
    }

    public S3Object getObjectDetailsWithSignedUrl(String signedHeadUrl) throws ServiceException {
        return this.getObjectWithSignedUrlImpl(signedHeadUrl, true);
    }

    public AccessControlList getObjectAclWithSignedUrl(String signedAclUrl) throws ServiceException {
        GetMethod httpMethod = new GetMethod(signedAclUrl);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        this.performRequest((HttpMethodBase)httpMethod, new int[]{200});
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    public void putObjectAclWithSignedUrl(String signedAclUrl, AccessControlList acl) throws ServiceException {
        PutMethod putMethod = new PutMethod(signedAclUrl);
        if (acl != null) {
            String restHeaderAclValue = acl.getValueForRESTHeaderACL();
            if (restHeaderAclValue != null) {
                putMethod.addRequestHeader(this.getRestHeaderPrefix() + "acl", restHeaderAclValue);
            } else {
                try {
                    String aclAsXml = acl.toXml();
                    putMethod.setRequestEntity((RequestEntity)new StringRequestEntity(aclAsXml, "text/xml", Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ServiceException("Unable to encode ACL XML document", e);
                }
            }
        }
        this.performRequest((HttpMethodBase)putMethod, new int[]{200});
        putMethod.releaseConnection();
    }

    private S3Object getObjectWithSignedUrlImpl(String signedGetOrHeadUrl, boolean headOnly) throws ServiceException {
        String s3Endpoint = this.getEndpoint();
        Object httpMethod = null;
        httpMethod = headOnly ? new HeadMethod(signedGetOrHeadUrl) : new GetMethod(signedGetOrHeadUrl);
        this.performRequest((HttpMethodBase)httpMethod, new int[]{200});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        S3Object responseObject = null;
        try {
            responseObject = ServiceUtils.buildObjectFromUrl(httpMethod.getURI().getHost(), httpMethod.getPath().substring(1), s3Endpoint);
        }
        catch (URIException e) {
            throw new ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HTTP_METHOD {
        PUT,
        POST,
        HEAD,
        GET,
        DELETE;

    }
}

