/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientDelegate;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.TimeLimitedLoggedPullImageResultCallback;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;

public class DockerClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DockerClientFactory.class);
    private final Object $lock = new Object[0];
    public static final ThreadGroup TESTCONTAINERS_THREAD_GROUP = new ThreadGroup("testcontainers");
    public static final String TESTCONTAINERS_LABEL = DockerClientFactory.class.getPackage().getName();
    public static final String TESTCONTAINERS_SESSION_ID_LABEL = TESTCONTAINERS_LABEL + ".sessionId";
    public static final String TESTCONTAINERS_LANG_LABEL = TESTCONTAINERS_LABEL + ".lang";
    public static final String TESTCONTAINERS_VERSION_LABEL = TESTCONTAINERS_LABEL + ".version";
    public static final String SESSION_ID = UUID.randomUUID().toString();
    public static final Map<String, String> DEFAULT_LABELS = DockerClientFactory.markerLabels();
    private static final DockerImageName TINY_IMAGE = DockerImageName.parse("alpine:3.16");
    private static DockerClientFactory instance;
    @VisibleForTesting
    DockerClientProviderStrategy strategy;
    @VisibleForTesting
    DockerClient client;
    @VisibleForTesting
    RuntimeException cachedClientFailure;
    private String activeApiVersion;
    private final AtomicReference<Object> fileMountingSupported = new AtomicReference();

    static Map<String, String> markerLabels() {
        String implementationVersion = DockerClientFactory.class.getPackage().getImplementationVersion();
        String testcontainersVersion = implementationVersion == null ? "unspecified" : implementationVersion;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(TESTCONTAINERS_LABEL, "true");
        labels.put(TESTCONTAINERS_LANG_LABEL, "java");
        labels.put(TESTCONTAINERS_VERSION_LABEL, testcontainersVersion);
        return Collections.unmodifiableMap(labels);
    }

    @VisibleForTesting
    DockerClientFactory() {
    }

    public static DockerClient lazyClient() {
        return new DockerClientDelegate(){

            protected DockerClient getDockerClient() {
                return DockerClientFactory.instance().client();
            }

            public String toString() {
                return "LazyDockerClient";
            }
        };
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    public synchronized boolean isDockerAvailable() {
        try {
            this.client();
            return true;
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockerClientProviderStrategy getOrInitializeStrategy() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy != null) {
                return this.strategy;
            }
            ArrayList<DockerClientProviderStrategy> configurationStrategies = new ArrayList<DockerClientProviderStrategy>();
            ServiceLoader.load(DockerClientProviderStrategy.class).forEach(configurationStrategies::add);
            this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(configurationStrategies);
            return this.strategy;
        }
    }

    public TransportConfig getTransportConfig() {
        return this.getOrInitializeStrategy().getTransportConfig();
    }

    public String getRemoteDockerUnixSocketPath() {
        String dockerSocketOverride;
        if (this.strategy != null && this.strategy.allowUserOverrides() && !StringUtils.isBlank(dockerSocketOverride = System.getenv("TESTCONTAINERS_DOCKER_SOCKET_OVERRIDE"))) {
            return dockerSocketOverride;
        }
        if (this.strategy != null && this.strategy.getRemoteDockerUnixSocketPath() != null) {
            return this.strategy.getRemoteDockerUnixSocketPath();
        }
        URI dockerHost = this.getTransportConfig().getDockerHost();
        String path = "unix".equals(dockerHost.getScheme()) ? dockerHost.getRawPath() : "/var/run/docker.sock";
        return SystemUtils.IS_OS_WINDOWS ? "/" + path : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client() {
        Object object = this.$lock;
        synchronized (object) {
            boolean checksEnabled;
            if (this.cachedClientFailure != null) {
                log.debug("There is a cached checks failure - throwing", (Throwable)this.cachedClientFailure);
                throw this.cachedClientFailure;
            }
            if (this.client != null) {
                return this.client;
            }
            final DockerClientProviderStrategy strategy = this.getOrInitializeStrategy();
            this.client = new DockerClientDelegate(){
                final DockerClient dockerClient;
                {
                    this.dockerClient = strategy.getDockerClient();
                }

                public void close() {
                    throw new IllegalStateException("You should never close the global DockerClient!");
                }

                public DockerClient getDockerClient() {
                    return this.dockerClient;
                }
            };
            log.info("Docker host IP address is {}", (Object)strategy.getDockerHostIpAddress());
            Info dockerInfo = strategy.getInfo();
            log.debug("Docker info: {}", (Object)dockerInfo.getRawValues());
            Version version = (Version)this.client.versionCmd().exec();
            log.debug("Docker version: {}", (Object)version.getRawValues());
            this.activeApiVersion = version.getApiVersion();
            log.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
            try {
                ResourceReaper.instance().init();
            }
            catch (RuntimeException e) {
                this.cachedClientFailure = e;
                throw e;
            }
            boolean bl = checksEnabled = !TestcontainersConfiguration.getInstance().isDisableChecks();
            if (checksEnabled) {
                log.debug("Checks are enabled");
                try {
                    log.info("Checking the system...");
                    this.checkDockerVersion(version.getVersion());
                }
                catch (RuntimeException e) {
                    this.cachedClientFailure = e;
                    throw e;
                }
            } else {
                log.debug("Checks are disabled");
            }
            return this.client;
        }
    }

    private void checkDockerVersion(String dockerVersion) {
        boolean versionIsSufficient = new ComparableVersion(dockerVersion).compareTo(new ComparableVersion("1.6.0")) >= 0;
        this.check("Docker server version should be at least 1.6.0", versionIsSufficient);
    }

    private void check(String message, boolean isSuccessful) {
        if (!isSuccessful) {
            log.error("\u274c {}", (Object)message);
            throw new IllegalStateException("Check failed: " + message);
        }
        log.info("\u2714\ufe0e {}", (Object)message);
    }

    private boolean checkMountableFile() {
        DockerClient dockerClient = this.client();
        MountableFile mountableFile = MountableFile.forClasspathResource(ResourceReaper.class.getName().replace(".", "/") + ".class");
        Volume volume = new Volume("/dummy");
        try {
            return this.runInsideDocker(createContainerCmd -> createContainerCmd.withBinds(new Bind[]{new Bind(mountableFile.getResolvedPath(), volume, AccessMode.ro)}), (__, containerId) -> {
                try (InputStream stream = dockerClient.copyArchiveFromContainerCmd(containerId, volume.getPath()).exec();){
                    stream.read();
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            log.debug("Failure while checking for mountable file support", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public void checkAndPullImage(DockerClient client, String image) {
        try {
            client.inspectImageCmd(image).exec();
        }
        catch (NotFoundException notFoundException) {
            PullImageCmd pullImageCmd = client.pullImageCmd(image);
            try {
                ((TimeLimitedLoggedPullImageResultCallback)pullImageCmd.exec((ResultCallback)new TimeLimitedLoggedPullImageResultCallback(log))).awaitCompletion();
            }
            catch (DockerClientException e) {
                ((TimeLimitedLoggedPullImageResultCallback)pullImageCmd.withPlatform("linux/amd64").exec((ResultCallback)new TimeLimitedLoggedPullImageResultCallback(log))).awaitCompletion();
            }
        }
    }

    public String dockerHostIpAddress() {
        return this.getOrInitializeStrategy().getDockerHostIpAddress();
    }

    public <T> T runInsideDocker(Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        return this.runInsideDocker(TINY_IMAGE, createContainerCmdConsumer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runInsideDocker(DockerImageName imageName, Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        RemoteDockerImage dockerImage = new RemoteDockerImage(imageName);
        HashMap<String, String> labels = new HashMap<String, String>(DEFAULT_LABELS);
        labels.putAll(ResourceReaper.instance().getLabels());
        CreateContainerCmd createContainerCmd = this.client.createContainerCmd((String)dockerImage.get()).withLabels(labels);
        createContainerCmdConsumer.accept(createContainerCmd);
        String id = createContainerCmd.exec().getId();
        try {
            this.client.startContainerCmd(id).exec();
            T t = block.apply(this.client, id);
            return t;
        }
        finally {
            try {
                this.client.removeContainerCmd(id).withRemoveVolumes(Boolean.valueOf(true)).withForce(Boolean.valueOf(true)).exec();
            }
            catch (InternalServerErrorException | NotFoundException e) {
                log.debug("Swallowed exception while removing container", e);
            }
        }
    }

    public String getActiveApiVersion() {
        this.client();
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        return this.getInfo().getExecutionDriver();
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return this.strategy != null && providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    public Info getInfo() {
        return this.getOrInitializeStrategy().getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileMountingSupported() {
        Object value = this.fileMountingSupported.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.fileMountingSupported;
            synchronized (atomicReference) {
                value = this.fileMountingSupported.get();
                if (value == null) {
                    boolean actualValue = this.checkMountableFile();
                    value = actualValue;
                    this.fileMountingSupported.set(value);
                }
            }
        }
        return (Boolean)value;
    }
}

