/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;

@Deprecated
public class DockerDesktopClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(DockerDesktopClientProviderStrategy.class);
    public static final int PRIORITY = 79;
    @Nullable
    private final AtomicReference<Object> socketPath = new AtomicReference();

    private Path resolveSocketPath() {
        Path linuxPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("desktop");
        return this.tryFolder(linuxPath).orElseGet(() -> {
            Path macosPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("run");
            return this.tryFolder(macosPath).orElse(null);
        });
    }

    @Override
    public String getDescription() {
        return "Docker accessed via Unix socket (" + this.getSocketPath() + ")";
    }

    @Override
    public TransportConfig getTransportConfig() throws InvalidConfigurationException {
        return TransportConfig.builder().dockerHost(URI.create("unix://" + this.getSocketPath().toString())).build();
    }

    @Override
    protected int getPriority() {
        return 79;
    }

    @Override
    protected boolean isPersistable() {
        return false;
    }

    @Override
    public String getRemoteDockerUnixSocketPath() {
        return "/var/run/docker.sock";
    }

    @Override
    protected boolean isApplicable() {
        return (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) && this.socketPath != null;
    }

    private Optional<Path> tryFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            log.debug("'{}' does not exist.", (Object)path);
            return Optional.empty();
        }
        Path socketPath = path.resolve("docker.sock");
        if (!Files.exists(socketPath, new LinkOption[0])) {
            log.debug("'{}' does not exist.", (Object)socketPath);
            return Optional.empty();
        }
        return Optional.of(socketPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path getSocketPath() {
        Object value = this.socketPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.socketPath;
            synchronized (atomicReference) {
                value = this.socketPath.get();
                if (value == null) {
                    Path actualValue = this.resolveSocketPath();
                    value = actualValue == null ? this.socketPath : actualValue;
                    this.socketPath.set(value);
                }
            }
        }
        return (Path)(value == this.socketPath ? null : value);
    }
}

