/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.testcontainers.shaded.org.apache.commons.lang3.builder.ToStringBuilder;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class CreateContainerCmdImpl
extends AbstrDockerCmd<CreateContainerCmd, CreateContainerResponse>
implements CreateContainerCmd {
    private String name;
    @JsonProperty(value="Hostname")
    private String hostName;
    @JsonProperty(value="Domainname")
    private String domainName;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="OpenStdin")
    private Boolean stdinOpen;
    @JsonProperty(value="StdinOnce")
    private Boolean stdInOnce;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Healthcheck")
    private HealthCheck healthcheck;
    @JsonProperty(value="ArgsEscaped")
    private Boolean argsEscaped;
    @JsonProperty(value="Entrypoint")
    private String[] entrypoint;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="WorkingDir")
    private String workingDir;
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="OnBuild")
    private List<String> onBuild;
    @JsonProperty(value="NetworkDisabled")
    private Boolean networkDisabled;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);
    @JsonProperty(value="StopSignal")
    private String stopSignal;
    @JsonProperty(value="StopTimeout")
    private Integer stopTimeout;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig = new HostConfig();
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Shell")
    private List<String> shell;
    @JsonProperty(value="NetworkingConfig")
    private NetworkingConfig networkingConfig;
    private String ipv4Address = null;
    private String ipv6Address = null;
    private List<String> aliases = null;
    private AuthConfig authConfig;
    private String platform;

    public CreateContainerCmdImpl(CreateContainerCmd.Exec exec, AuthConfig authConfig, String image) {
        super(exec);
        this.withAuthConfig(authConfig);
        this.withImage(image);
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public CreateContainerCmd withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public CreateContainerCmd withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    public CreateContainerCmd withAliases(List<String> aliases) {
        Preconditions.checkNotNull(aliases, "aliases was not specified");
        this.aliases = aliases;
        return this;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public CreateContainerCmd withCmd(String ... cmd) {
        Preconditions.checkNotNull(cmd, "cmd was not specified");
        this.cmd = cmd;
        return this;
    }

    public CreateContainerCmd withCmd(List<String> cmd) {
        Preconditions.checkNotNull(cmd, "cmd was not specified");
        return this.withCmd(cmd.toArray(new String[0]));
    }

    @CheckForNull
    public HealthCheck getHealthcheck() {
        return this.healthcheck;
    }

    public CreateContainerCmdImpl withHealthcheck(HealthCheck healthcheck) {
        this.healthcheck = healthcheck;
        return this;
    }

    public Boolean getArgsEscaped() {
        return this.argsEscaped;
    }

    public CreateContainerCmdImpl withArgsEscaped(Boolean argsEscaped) {
        this.argsEscaped = argsEscaped;
        return this;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public CreateContainerCmd withDomainName(String domainName) {
        Preconditions.checkNotNull(domainName, "no domainName was specified");
        this.domainName = domainName;
        return this;
    }

    public String[] getEntrypoint() {
        return this.entrypoint;
    }

    public CreateContainerCmd withEntrypoint(String ... entrypoint) {
        Preconditions.checkNotNull(entrypoint, "entrypoint was not specified");
        this.entrypoint = entrypoint;
        return this;
    }

    public CreateContainerCmd withEntrypoint(List<String> entrypoint) {
        Preconditions.checkNotNull(entrypoint, "entrypoint was not specified");
        return this.withEntrypoint(entrypoint.toArray(new String[0]));
    }

    public String[] getEnv() {
        return this.env;
    }

    public CreateContainerCmd withEnv(String ... env) {
        Preconditions.checkNotNull(env, "env was not specified");
        this.env = env;
        return this;
    }

    public CreateContainerCmd withEnv(List<String> env) {
        Preconditions.checkNotNull(env, "env was not specified");
        return this.withEnv(env.toArray(new String[0]));
    }

    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    public CreateContainerCmd withExposedPorts(ExposedPort ... exposedPorts) {
        Preconditions.checkNotNull(exposedPorts, "exposedPorts was not specified");
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    public CreateContainerCmd withExposedPorts(List<ExposedPort> exposedPorts) {
        Preconditions.checkNotNull(exposedPorts, "exposedPorts was not specified");
        return this.withExposedPorts(exposedPorts.toArray(new ExposedPort[0]));
    }

    public String getStopSignal() {
        return this.stopSignal;
    }

    public CreateContainerCmd withStopSignal(String stopSignal) {
        Preconditions.checkNotNull(stopSignal, "stopSignal wasn't specified.");
        this.stopSignal = stopSignal;
        return this;
    }

    public Integer getStopTimeout() {
        return this.stopTimeout;
    }

    public CreateContainerCmd withStopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public CreateContainerCmd withHostName(String hostName) {
        Preconditions.checkNotNull(hostName, "no hostName was specified");
        this.hostName = hostName;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public CreateContainerCmd withImage(String image) {
        Preconditions.checkNotNull(image, "no image was specified");
        this.image = image;
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public CreateContainerCmd withLabels(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.labels = labels;
        return this;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public CreateContainerCmd withMacAddress(String macAddress) {
        Preconditions.checkNotNull(macAddress, "macAddress was not specified");
        this.macAddress = macAddress;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CreateContainerCmd withName(String name) {
        Preconditions.checkNotNull(name, "name was not specified");
        this.name = name;
        return this;
    }

    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    public CreateContainerCmd withPortSpecs(String ... portSpecs) {
        Preconditions.checkNotNull(portSpecs, "portSpecs was not specified");
        this.portSpecs = portSpecs;
        return this;
    }

    public CreateContainerCmd withPortSpecs(List<String> portSpecs) {
        Preconditions.checkNotNull(portSpecs, "portSpecs was not specified");
        return this.withPortSpecs(portSpecs.toArray(new String[0]));
    }

    public String getUser() {
        return this.user;
    }

    public CreateContainerCmd withUser(String user) {
        Preconditions.checkNotNull(user, "user was not specified");
        this.user = user;
        return this;
    }

    public Boolean isAttachStderr() {
        return this.attachStderr;
    }

    public CreateContainerCmd withAttachStderr(Boolean attachStderr) {
        Preconditions.checkNotNull(attachStderr, "attachStderr was not specified");
        this.attachStderr = attachStderr;
        return this;
    }

    public Boolean isAttachStdin() {
        return this.attachStdin;
    }

    public CreateContainerCmd withAttachStdin(Boolean attachStdin) {
        Preconditions.checkNotNull(attachStdin, "attachStdin was not specified");
        this.attachStdin = attachStdin;
        return this;
    }

    public Boolean isAttachStdout() {
        return this.attachStdout;
    }

    public CreateContainerCmd withAttachStdout(Boolean attachStdout) {
        Preconditions.checkNotNull(attachStdout, "attachStdout was not specified");
        this.attachStdout = attachStdout;
        return this;
    }

    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    public CreateContainerCmd withVolumes(Volume ... volumes) {
        Preconditions.checkNotNull(volumes, "volumes was not specified");
        this.volumes = new Volumes(volumes);
        return this;
    }

    public CreateContainerCmd withVolumes(List<Volume> volumes) {
        Preconditions.checkNotNull(volumes, "volumes was not specified");
        return this.withVolumes(volumes.toArray(new Volume[0]));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public CreateContainerCmd withWorkingDir(String workingDir) {
        Preconditions.checkNotNull(workingDir, "workingDir was not specified");
        this.workingDir = workingDir;
        return this;
    }

    public Boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    public CreateContainerCmd withNetworkDisabled(Boolean disableNetwork) {
        Preconditions.checkNotNull(disableNetwork, "disableNetwork was not specified");
        this.networkDisabled = disableNetwork;
        return this;
    }

    public Boolean isStdInOnce() {
        return this.stdInOnce;
    }

    public CreateContainerCmd withStdInOnce(Boolean stdInOnce) {
        Preconditions.checkNotNull(stdInOnce, "no stdInOnce was specified");
        this.stdInOnce = stdInOnce;
        return this;
    }

    public Boolean isStdinOpen() {
        return this.stdinOpen;
    }

    public CreateContainerCmd withStdinOpen(Boolean stdinOpen) {
        Preconditions.checkNotNull(stdinOpen, "no stdinOpen was specified");
        this.stdinOpen = stdinOpen;
        return this;
    }

    public Boolean isTty() {
        return this.tty;
    }

    public CreateContainerCmd withTty(Boolean tty) {
        Preconditions.checkNotNull(tty, "no tty was specified");
        this.tty = tty;
        return this;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public CreateContainerCmd withHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
        return this;
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public CreateContainerCmd withIpv4Address(String ipv4Address) {
        Preconditions.checkNotNull(ipv4Address, "no ipv4Address was specified");
        this.ipv4Address = ipv4Address;
        return this;
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    public CreateContainerCmd withIpv6Address(String ipv6Address) {
        Preconditions.checkNotNull(ipv6Address, "no ipv6Address was specified");
        this.ipv6Address = ipv6Address;
        return this;
    }

    @CheckForNull
    public List<String> getOnBuild() {
        return this.onBuild;
    }

    public CreateContainerCmdImpl withOnBuild(List<String> onBuild) {
        this.onBuild = onBuild;
        return this;
    }

    @CheckForNull
    public String getPlatform() {
        return this.platform;
    }

    public CreateContainerCmd withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException {
        ContainerNetwork containerNetwork = null;
        if (this.ipv4Address != null || this.ipv6Address != null) {
            containerNetwork = new ContainerNetwork().withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address(this.ipv4Address).withIpv6Address(this.ipv6Address));
        }
        if (this.hostConfig.isUserDefinedNetwork() && this.hostConfig.getLinks().length > 0) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withLinks(this.hostConfig.getLinks());
        }
        if (this.aliases != null) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withAliases(this.aliases);
        }
        if (containerNetwork != null && this.hostConfig.getNetworkMode() != null) {
            this.networkingConfig = new NetworkingConfig().withEndpointsConfig(Collections.singletonMap(this.hostConfig.getNetworkMode(), containerNetwork));
        }
        return (CreateContainerResponse)super.exec();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, o, new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public static class NetworkingConfig {
        @JsonProperty(value="EndpointsConfig")
        public Map<String, ContainerNetwork> endpointsConfig;

        public Map<String, ContainerNetwork> getEndpointsConfig() {
            return this.endpointsConfig;
        }

        public NetworkingConfig withEndpointsConfig(Map<String, ContainerNetwork> endpointsConfig) {
            this.endpointsConfig = endpointsConfig;
            return this;
        }
    }
}

