/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.IndefiniteWaitOneShotStartupCheckStrategy;
import org.testcontainers.shaded.com.google.common.base.Joiner;
import org.testcontainers.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.testcontainers.utility.AuditLogger;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.PathUtils;

class ContainerisedDockerCompose
extends GenericContainer<ContainerisedDockerCompose>
implements DockerCompose {
    public static final char UNIX_PATH_SEPARATOR = ':';

    public ContainerisedDockerCompose(DockerImageName dockerImageName, List<File> composeFiles, String identifier, List<String> fileCopyInclusions) {
        super(dockerImageName);
        this.addEnv("COMPOSE_PROJECT_NAME", identifier);
        File dockerComposeBaseFile = composeFiles.get(0);
        String pwd = dockerComposeBaseFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        String containerPwd = this.convertToUnixFilesystemPath(pwd);
        List absoluteDockerComposeFiles = composeFiles.stream().map(File::getAbsolutePath).map(MountableFile::forHostPath).map(MountableFile::getFilesystemPath).map(this::convertToUnixFilesystemPath).collect(Collectors.toList());
        String composeFileEnvVariableValue = Joiner.on(':').join(absoluteDockerComposeFiles);
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        this.addEnv("COMPOSE_FILE", composeFileEnvVariableValue);
        if (fileCopyInclusions.isEmpty()) {
            this.logger().info("Copying all files in {} into the container", (Object)pwd);
            this.withCopyFileToContainer(MountableFile.forHostPath(pwd), containerPwd);
        } else {
            this.logger().info("Copying docker compose file: {}", (Object)dockerComposeBaseFile.getAbsolutePath());
            this.withCopyFileToContainer(MountableFile.forHostPath(dockerComposeBaseFile.getAbsolutePath()), this.convertToUnixFilesystemPath(dockerComposeBaseFile.getAbsolutePath()));
            for (String pathToCopy : fileCopyInclusions) {
                String hostPath = pwd + "/" + pathToCopy;
                this.logger().info("Copying inclusion file: {}", (Object)hostPath);
                this.withCopyFileToContainer(MountableFile.forHostPath(hostPath), this.convertToUnixFilesystemPath(hostPath));
            }
        }
        this.addFileSystemBind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        this.setStartupCheckStrategy(new IndefiniteWaitOneShotStartupCheckStrategy());
        this.setWorkingDirectory(containerPwd);
    }

    @Override
    public void invoke() {
        super.start();
        this.followOutput(new Slf4jLogConsumer(this.logger()));
        this.logger().info("Docker Compose container is running for command: {}", (Object)Joiner.on(" ").join(this.getCommandParts()));
        while (this.isRunning()) {
            this.logger().trace("Compose container is still running");
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        AuditLogger.doComposeLog(this.getCommandParts(), this.getEnv());
        Integer exitCode = this.getDockerClient().inspectContainerCmd(this.getContainerId()).exec().getState().getExitCode();
        if (exitCode == null || exitCode != 0) {
            throw new ContainerLaunchException("Containerised Docker Compose exited abnormally with code " + exitCode + " whilst running command: " + StringUtils.join((Object[])this.getCommandParts(), (char)' '));
        }
        this.logger().info("Docker Compose has finished running");
    }

    private String convertToUnixFilesystemPath(String path) {
        return SystemUtils.IS_OS_WINDOWS ? PathUtils.createMinGWPath(path).substring(1) : path;
    }
}

