/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.model.PullResponseItem;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.LoggedPullImageResultCallback;
import org.testcontainers.utility.TestcontainersConfiguration;

public class TimeLimitedLoggedPullImageResultCallback
extends LoggedPullImageResultCallback {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    private static final ScheduledExecutorService PROGRESS_WATCHDOG_EXECUTOR = Executors.newScheduledThreadPool(0, runnable -> {
        Thread t2 = new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, runnable);
        t2.setDaemon(true);
        t2.setName("testcontainers-pull-watchdog-" + THREAD_ID.incrementAndGet());
        return t2;
    });
    private static final Duration PULL_PAUSE_TOLERANCE = Duration.ofSeconds(TestcontainersConfiguration.getInstance().getImagePullPauseTimeout().intValue());
    private final Logger logger;
    private ScheduledFuture<?> nextCheckForProgress;
    private final Set<Thread> waitingThreads = new HashSet<Thread>();

    public TimeLimitedLoggedPullImageResultCallback(Logger logger) {
        super(logger);
        this.logger = logger;
    }

    public TimeLimitedLoggedPullImageResultCallback awaitCompletion() throws InterruptedException {
        this.waitingThreads.add(Thread.currentThread());
        super.awaitCompletion();
        return this;
    }

    public boolean awaitCompletion(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.waitingThreads.add(Thread.currentThread());
        return super.awaitCompletion(timeout, timeUnit);
    }

    @Override
    public void onNext(PullResponseItem item) {
        if (item.getProgressDetail() != null) {
            this.resetProgressWatchdog(false);
        }
        super.onNext(item);
    }

    @Override
    public void onStart(Closeable stream) {
        this.resetProgressWatchdog(false);
        super.onStart(stream);
    }

    public void onError(Throwable throwable) {
        this.resetProgressWatchdog(true);
        super.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.resetProgressWatchdog(true);
        super.onComplete();
    }

    private void resetProgressWatchdog(boolean isFinished) {
        if (this.nextCheckForProgress != null && !this.nextCheckForProgress.isCancelled()) {
            this.nextCheckForProgress.cancel(false);
        }
        if (!isFinished) {
            this.nextCheckForProgress = PROGRESS_WATCHDOG_EXECUTOR.schedule(this::abortPull, PULL_PAUSE_TOLERANCE.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void abortPull() {
        this.logger.error("Docker image pull has not made progress in {}s - aborting pull", (Object)PULL_PAUSE_TOLERANCE.getSeconds());
        this.waitingThreads.forEach(Thread::interrupt);
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

