/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Frame;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrAsyncDockerCmd;

public class LogContainerCmdImpl
extends AbstrAsyncDockerCmd<LogContainerCmd, Frame>
implements LogContainerCmd {
    private String containerId;
    private Boolean followStream;
    private Boolean timestamps;
    private Boolean stdout;
    private Boolean stderr;
    private Integer tail;
    private Integer since;
    private Integer until;

    public LogContainerCmdImpl(LogContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Integer getTail() {
        return this.tail;
    }

    public Boolean hasFollowStreamEnabled() {
        return this.followStream;
    }

    public Boolean hasTimestampsEnabled() {
        return this.timestamps;
    }

    public Boolean hasStdoutEnabled() {
        return this.stdout;
    }

    public Boolean hasStderrEnabled() {
        return this.stderr;
    }

    public Integer getSince() {
        return this.since;
    }

    public Integer getUntil() {
        return this.until;
    }

    public LogContainerCmd withContainerId(String containerId) {
        this.containerId = Objects.requireNonNull(containerId, "containerId was not specified");
        return this;
    }

    public LogContainerCmd withFollowStream(Boolean followStream) {
        this.followStream = followStream;
        return this;
    }

    public LogContainerCmd withTimestamps(Boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public LogContainerCmd withStdOut(Boolean stdout) {
        this.stdout = stdout;
        return this;
    }

    public LogContainerCmd withStdErr(Boolean stderr) {
        this.stderr = stderr;
        return this;
    }

    public LogContainerCmd withTailAll() {
        this.tail = -1;
        return this;
    }

    public LogContainerCmd withTail(Integer tail) {
        this.tail = tail;
        return this;
    }

    public LogContainerCmd withSince(Integer since) {
        this.since = since;
        return this;
    }

    public LogContainerCmd withUntil(Integer until) {
        this.until = until;
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

