/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PSSParameterSpec;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.testcontainers.shaded.org.bouncycastle.asn1.DERNull;
import org.testcontainers.shaded.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.testcontainers.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.Extensions;
import org.testcontainers.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;

class X509SignatureUtil {
    X509SignatureUtil() {
    }

    static byte[] getExtensionValue(Extensions extensions, String string) {
        ASN1OctetString aSN1OctetString;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (string != null && (aSN1ObjectIdentifier = ASN1ObjectIdentifier.tryFromID(string)) != null && null != (aSN1OctetString = Extensions.getExtensionValue(extensions, aSN1ObjectIdentifier))) {
            try {
                return aSN1OctetString.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    private static boolean isAbsentOrEmptyParameters(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable == null || DERNull.INSTANCE.equals(aSN1Encodable);
    }

    static void setSignatureParameters(Signature signature, ASN1Encodable aSN1Encodable) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!X509SignatureUtil.isAbsentOrEmptyParameters(aSN1Encodable)) {
            String string = signature.getAlgorithm();
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string, signature.getProvider());
            try {
                algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded());
            }
            catch (IOException iOException) {
                throw new SignatureException("IOException decoding parameters: " + iOException.getMessage());
            }
            if (string.endsWith("MGF1")) {
                try {
                    signature.setParameter(algorithmParameters.getParameterSpec(PSSParameterSpec.class));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SignatureException("Exception extracting parameters: " + generalSecurityException.getMessage());
                }
            }
        }
    }

    static String getSignatureName(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (!X509SignatureUtil.isAbsentOrEmptyParameters(aSN1Encodable)) {
            if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals(aSN1ObjectIdentifier)) {
                RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(aSN1Encodable);
                return X509SignatureUtil.getDigestAlgName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()) + "withRSAandMGF1";
            }
            if (X9ObjectIdentifiers.ecdsa_with_SHA2.equals(aSN1ObjectIdentifier)) {
                AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(aSN1Encodable);
                return X509SignatureUtil.getDigestAlgName(algorithmIdentifier2.getAlgorithm()) + "withECDSA";
            }
        }
        return aSN1ObjectIdentifier.getId();
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(aSN1ObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(aSN1ObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(aSN1ObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(aSN1ObjectIdentifier)) {
            return "GOST3411";
        }
        return aSN1ObjectIdentifier.getId();
    }
}

