/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.command.DockerCmd;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.google.common.base.Strings;

public final class AuditLogger {
    private static final Logger log = LoggerFactory.getLogger(AuditLogger.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String MDC_PREFIX = AuditLogger.class.getCanonicalName();

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd) {
        AuditLogger.doLog(action, image, containerId, cmd, null);
    }

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd, @Nullable Exception e) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put((String)(MDC_PREFIX + ".Action"), (String)Strings.nullToEmpty(action));
        MDC.put((String)(MDC_PREFIX + ".Image"), (String)Strings.nullToEmpty(image));
        MDC.put((String)(MDC_PREFIX + ".ContainerId"), (String)Strings.nullToEmpty(containerId));
        try {
            MDC.put((String)(MDC_PREFIX + ".Command"), (String)objectMapper.writeValueAsString(cmd));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        if (e != null) {
            MDC.put((String)(MDC_PREFIX + ".Exception"), (String)e.getLocalizedMessage());
            log.trace("{} action with image: {}, containerId: {}", new Object[]{action, image, containerId, e});
        } else {
            log.trace("{} action with image: {}, containerId: {}", new Object[]{action, image, containerId});
        }
        MDC.remove((String)(MDC_PREFIX + ".Action"));
        MDC.remove((String)(MDC_PREFIX + ".Image"));
        MDC.remove((String)(MDC_PREFIX + ".ContainerId"));
        MDC.remove((String)(MDC_PREFIX + ".Command"));
        MDC.remove((String)(MDC_PREFIX + ".Exception"));
    }

    public static void doComposeLog(@NotNull String[] commandParts, @Nullable List<String> env) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put((String)(MDC_PREFIX + ".Action"), (String)"COMPOSE");
        if (env != null) {
            MDC.put((String)(MDC_PREFIX + ".Compose.Env"), (String)env.toString());
        }
        String command = StringUtils.join((Object[])commandParts, (char)' ');
        MDC.put((String)(MDC_PREFIX + ".Compose.Command"), (String)command);
        log.trace("COMPOSE action with command: {}, env: {}", (Object)command, env);
        MDC.remove((String)(MDC_PREFIX + ".Action"));
        MDC.remove((String)(MDC_PREFIX + ".Compose.Command"));
        MDC.remove((String)(MDC_PREFIX + ".Compose.Env"));
    }

    private AuditLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

