/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathScanner.class);

    ClasspathScanner() {
    }

    @VisibleForTesting
    static Stream<URL> scanFor(String name, ClassLoader ... classLoaders) {
        return Stream.of(classLoaders).flatMap(classLoader -> ClasspathScanner.getAllPropertyFilesOnClassloader(classLoader, name)).filter(Objects::nonNull).sorted(Comparator.comparing(ClasspathScanner::filesFileSchemeFirst).thenComparing(URL::toString)).distinct();
    }

    private static Integer filesFileSchemeFirst(URL t2) {
        return t2.getProtocol().equals("file") ? 0 : 1;
    }

    static Stream<URL> scanFor(String name) {
        return ClasspathScanner.scanFor(name, ClasspathScanner.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    private static Stream<URL> getAllPropertyFilesOnClassloader(ClassLoader it, String s2) {
        try {
            return Collections.list(it.getResources(s2)).stream();
        }
        catch (Exception e) {
            log.error("Unable to read configuration from classloader {} - this is probably a bug", (Object)it, (Object)e);
            return Stream.empty();
        }
    }
}

