/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.SuiteResultCounts;
import org.testng.SuiteRunner;
import org.testng.collections.Lists;
import org.testng.internal.PoolService;
import org.testng.internal.Utils;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRunnerWorker
implements IWorker<ISuite> {
    private SuiteRunner m_suiteRunner;
    private Integer m_verbose;
    private String m_defaultSuiteName;
    private Map<XmlSuite, ISuite> m_suiteRunnerMap;

    public SuiteRunnerWorker(ISuite suiteRunner, Map<XmlSuite, ISuite> suiteRunnerMap, int verbose, String defaultSuiteName) {
        this.m_suiteRunnerMap = suiteRunnerMap;
        this.m_suiteRunner = (SuiteRunner)suiteRunner;
        this.m_verbose = verbose;
        this.m_defaultSuiteName = defaultSuiteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSuite(Map<XmlSuite, ISuite> suiteRunnerMap, XmlSuite xmlSuite) {
        if (this.m_verbose > 0) {
            StringBuffer allFiles = new StringBuffer();
            allFiles.append("  ").append(xmlSuite.getFileName() != null ? xmlSuite.getFileName() : this.m_defaultSuiteName).append('\n');
            Utils.log("TestNG", 0, "Running:\n" + allFiles.toString());
        }
        PoolService.initialize(xmlSuite.getDataProviderThreadCount());
        SuiteRunner suiteRunner = (SuiteRunner)suiteRunnerMap.get(xmlSuite);
        suiteRunner.run();
        if (xmlSuite.getVerbose() > 0) {
            SuiteResultCounts counts = new SuiteResultCounts();
            Map<XmlSuite, ISuite> map = suiteRunnerMap;
            synchronized (map) {
                counts.calculateResultCounts(xmlSuite, suiteRunnerMap);
            }
            StringBuffer bufLog = new StringBuffer("\n===============================================\n").append(xmlSuite.getName());
            bufLog.append("\nTotal tests run: ").append(counts.m_total).append(", Failures: ").append(counts.m_failed).append(", Skips: ").append(counts.m_skipped);
            if (counts.m_confFailures > 0 || counts.m_confSkips > 0) {
                bufLog.append("\nConfiguration Failures: ").append(counts.m_confFailures).append(", Skips: ").append(counts.m_confSkips);
            }
            bufLog.append("\n===============================================\n");
            System.out.println(bufLog.toString());
        }
    }

    @Override
    public void run() {
        this.runSuite(this.m_suiteRunnerMap, this.m_suiteRunner.getXmlSuite());
    }

    @Override
    public int compareTo(IWorker<ISuite> arg0) {
        return 0;
    }

    @Override
    public List<ISuite> getTasks() {
        List<ISuite> suiteRunnerList = Lists.newArrayList();
        suiteRunnerList.add(this.m_suiteRunner);
        return suiteRunnerList;
    }

    public String toString() {
        return "SuiteRunnerWorker(" + this.m_suiteRunner.getName() + ")";
    }

    @Override
    public long getTimeOut() {
        return this.m_suiteRunner.getXmlSuite().getTimeOut(Long.MAX_VALUE);
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

