/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.util.ReflectionUtils;

public class ModulesRepository {
    private List<Module> modules;
    private Map<Module, TestListener> testListeners;

    public ModulesRepository(List<Module> modules) {
        this.modules = modules;
        this.testListeners = this.createTestListeners(modules);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public Map<Module, TestListener> getTestListeners() {
        return this.testListeners;
    }

    public <T extends Module> T getModuleOfType(Class<T> type) {
        List<T> modulesOfType = this.getModulesOfType(type);
        if (modulesOfType.size() > 1) {
            throw new UnitilsException("More than one module found of type " + type.getName());
        }
        if (modulesOfType.size() < 1) {
            throw new UnitilsException("No module found of type " + type.getName());
        }
        return (T)((Module)modulesOfType.get(0));
    }

    public <T> List<T> getModulesOfType(Class<T> type) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : this.modules) {
            if (!type.isAssignableFrom(module.getClass())) continue;
            result.add(module);
        }
        return result;
    }

    public boolean isModuleEnabled(String fullyQualifiedClassName) {
        Class moduleClass;
        try {
            moduleClass = ReflectionUtils.getClassWithName(fullyQualifiedClassName);
        }
        catch (UnitilsException e) {
            return false;
        }
        return this.isModuleEnabled(moduleClass);
    }

    public boolean isModuleEnabled(Class<? extends Module> moduleClass) {
        List<? extends Module> modulesOfType = this.getModulesOfType(moduleClass);
        if (modulesOfType.size() > 1) {
            throw new UnitilsException("More than one module found of type " + moduleClass.getName());
        }
        return modulesOfType.size() == 1;
    }

    public TestListener getTestListener(Module module) {
        return this.testListeners.get(module);
    }

    private Map<Module, TestListener> createTestListeners(List<Module> moduleList) {
        HashMap<Module, TestListener> result = new HashMap<Module, TestListener>(moduleList.size());
        for (Module module : moduleList) {
            result.put(module, module.getTestListener());
        }
        return result;
    }
}

