/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.util.Collection;
import java.util.Map;
import org.unitils.core.util.ObjectFormatter;

public class ArrayAndCollectionFormatter {
    protected int maxNrOfElements;
    protected ObjectFormatter objectFormatter;

    public ArrayAndCollectionFormatter(int maxNrOfElements, ObjectFormatter objectFormatter) {
        this.maxNrOfElements = maxNrOfElements;
        this.objectFormatter = objectFormatter;
    }

    public void formatArray(Object array, int currentDepth, StringBuilder result) {
        if (array instanceof byte[]) {
            this.formatByteArray((byte[])array, result);
            return;
        }
        if (array instanceof short[]) {
            this.formatShortArray((short[])array, result);
            return;
        }
        if (array instanceof int[]) {
            this.formatIntArray((int[])array, result);
            return;
        }
        if (array instanceof long[]) {
            this.formatLongArray((long[])array, result);
            return;
        }
        if (array instanceof char[]) {
            this.formatCharArray((char[])array, result);
            return;
        }
        if (array instanceof float[]) {
            this.formatFloatArray((float[])array, result);
            return;
        }
        if (array instanceof double[]) {
            this.formatDoubleArray((double[])array, result);
            return;
        }
        if (array instanceof boolean[]) {
            this.formatBooleanArray((boolean[])array, result);
            return;
        }
        this.formatObjectArray((Object[])array, currentDepth, result);
    }

    public void formatCollection(Collection<?> collection, int currentDepth, StringBuilder result) {
        result.append("[");
        int count = 0;
        for (Object element : collection) {
            if (count++ > 0) {
                result.append(", ");
            }
            this.objectFormatter.formatImpl(element, currentDepth + 1, result);
            if (count < this.maxNrOfElements || count >= collection.size()) continue;
            result.append(", ...");
            break;
        }
        result.append("]");
    }

    public void formatMap(Map<?, ?> map, int currentDepth, StringBuilder result) {
        result.append("{");
        int count = 0;
        for (Map.Entry<?, ?> element : map.entrySet()) {
            if (count++ > 0) {
                result.append(", ");
            }
            this.objectFormatter.formatImpl(element.getKey(), currentDepth, result);
            result.append("=");
            this.objectFormatter.formatImpl(element.getValue(), currentDepth + 1, result);
            if (count < this.maxNrOfElements || count >= map.size()) continue;
            result.append(", ...");
            break;
        }
        result.append("}");
    }

    protected void formatObjectArray(Object[] array, int currentDepth, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            this.objectFormatter.formatImpl(array[i], currentDepth + 1, result);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatByteArray(byte[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatShortArray(short[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatIntArray(int[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatLongArray(long[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatCharArray(char[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append('\'');
            result.append(array[i]);
            result.append('\'');
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatFloatArray(float[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatDoubleArray(double[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }

    protected void formatBooleanArray(boolean[] array, StringBuilder result) {
        int i;
        result.append("[");
        for (i = 0; i < array.length && i < this.maxNrOfElements; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(array[i]);
        }
        if (i < array.length) {
            result.append(", ...");
        }
        result.append("]");
    }
}

