/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.unitils.core.UnitilsException;

public class FileResolver {
    protected boolean prefixWithPackageName;
    protected String pathPrefix;

    public FileResolver() {
        this(true, null);
    }

    public FileResolver(boolean prefixWithPackageName, String pathPrefix) {
        this.prefixWithPackageName = prefixWithPackageName;
        this.pathPrefix = pathPrefix;
    }

    public URI resolveDefaultFileName(String extension, Class<?> testClass) {
        String fileName = this.getDefaultFileName(extension, testClass);
        return this.resolveFileName(fileName, testClass);
    }

    public URI resolveFileName(String fileName, Class<?> testClass) {
        String fullFileName = this.constructFullFileName(fileName, testClass);
        if (fullFileName.startsWith("/")) {
            File file = new File(fullFileName);
            if (!file.exists()) {
                throw new UnitilsException("File with name " + fullFileName + " cannot be found.");
            }
            return file.toURI();
        }
        URL fileUrl = testClass.getResource('/' + fullFileName);
        if (fileUrl == null) {
            throw new UnitilsException("File with name " + fullFileName + " cannot be found.");
        }
        try {
            return fileUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new UnitilsException("File with name " + fullFileName + " cannot be found.", e);
        }
    }

    public boolean isPrefixWithPackageName() {
        return this.prefixWithPackageName;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    protected String constructFullFileName(String fileName, Class<?> testClass) {
        if (this.prefixWithPackageName && !fileName.startsWith("/")) {
            fileName = this.prefixPackageNameFilePath(fileName, testClass);
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if (this.pathPrefix != null) {
            fileName = this.pathPrefix + '/' + fileName;
        }
        return fileName;
    }

    protected String prefixPackageNameFilePath(String fileName, Class<?> testClass) {
        String className = testClass.getName();
        int indexOfLastDot = className.lastIndexOf(46);
        if (indexOfLastDot == -1) {
            return fileName;
        }
        String packageName = className.substring(0, indexOfLastDot).replace('.', '/');
        return packageName + '/' + fileName;
    }

    protected String getDefaultFileName(String extension, Class<?> testClass) {
        String className = testClass.getName();
        return className.substring(className.lastIndexOf(".") + 1) + '.' + extension;
    }
}

