/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.report.impl;

import junit.framework.AssertionFailedError;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.report.DifferenceView;

public class SimpleDifferenceView
implements DifferenceView {
    private ObjectFormatter objectFormatter = new ObjectFormatter();

    @Override
    public String createView(Difference difference) {
        String expectedStr = this.objectFormatter.format(difference.getLeftValue());
        String actualStr = this.objectFormatter.format(difference.getRightValue());
        String formattedOnOneLine = this.formatOnOneLine(expectedStr, actualStr);
        if (AssertionFailedError.class.getName().length() + 2 + formattedOnOneLine.length() < 110) {
            return formattedOnOneLine;
        }
        return this.formatOnTwoLines(expectedStr, actualStr);
    }

    protected String formatOnOneLine(String expectedStr, String actualStr) {
        return "Expected: " + expectedStr + ", actual: " + actualStr;
    }

    protected String formatOnTwoLines(String expectedStr, String actualStr) {
        StringBuilder result = new StringBuilder();
        result.append("\nExpected: ").append(expectedStr);
        result.append("\n  Actual: ").append(actualStr);
        return result.toString();
    }
}

