/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiFormat {
    public static WikiFormat EMPTY = new WikiFormat();
    private String fClosingTags;
    private String fOpeningTags;
    private LinkedHashSet<WikiStyle> fStyles = new LinkedHashSet();
    private WikiParameters fParams = WikiParameters.EMPTY;

    public WikiFormat() {
    }

    public WikiFormat(Set<WikiStyle> styles) {
        this(styles, Collections.emptyList());
    }

    public WikiFormat(Set<WikiStyle> styles, Collection<WikiParameter> params) {
        if (!styles.isEmpty()) {
            this.fStyles.addAll(styles);
        }
        if (!params.isEmpty()) {
            this.fParams = new WikiParameters(params);
        }
    }

    public WikiFormat(Collection<WikiParameter> params) {
        this(Collections.emptySet(), params);
    }

    public WikiFormat(WikiStyle style) {
        this(Collections.singleton(style));
    }

    public WikiFormat(WikiStyle style, Collection<WikiParameter> params) {
        this(Collections.singleton(style), params);
    }

    public WikiFormat(WikiStyle[] styles) {
        for (WikiStyle style : styles) {
            this.fStyles.add(style);
        }
    }

    public WikiFormat setParameters(Collection<WikiParameter> params) {
        return new WikiFormat(this.fStyles, params);
    }

    public WikiFormat addStyle(WikiStyle style) {
        if (this.fStyles.contains(style)) {
            return this;
        }
        WikiFormat clone = this.getClone();
        clone.fStyles.add(style);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WikiFormat)) {
            return false;
        }
        WikiFormat set = (WikiFormat)obj;
        return this.fStyles.equals(set.fStyles) && this.fParams.equals(set.fParams);
    }

    protected WikiFormat getClone() {
        return new WikiFormat(this.fStyles, this.fParams.toList());
    }

    public String getTags(boolean open) {
        if (this.fOpeningTags == null) {
            StringBuffer o = new StringBuffer();
            StringBuffer c = new StringBuffer();
            for (WikiStyle style : this.fStyles) {
                o.append("<").append(style).append(">");
                c.insert(0, ">").insert(0, style).insert(0, "</");
            }
            this.fOpeningTags = o.toString().intern();
            this.fClosingTags = c.toString().intern();
        }
        return open ? this.fOpeningTags : this.fClosingTags;
    }

    public int hashCode() {
        int hash = 8;
        hash = 31 * hash + (null == this.fStyles ? 0 : this.fStyles.hashCode());
        hash = 31 * hash + (null == this.fParams ? 0 : this.fParams.hashCode());
        return hash;
    }

    public boolean hasStyle(WikiStyle style) {
        return this.fStyles.contains(style);
    }

    public WikiFormat removeStyle(WikiStyle style) {
        if (!this.fStyles.contains(style)) {
            return this;
        }
        WikiFormat clone = this.getClone();
        clone.fStyles.remove(style);
        return clone;
    }

    public WikiFormat switchStyle(WikiStyle wikiStyle) {
        WikiFormat clone = this.getClone();
        if (clone.fStyles.contains(wikiStyle)) {
            clone.fStyles.remove(wikiStyle);
        } else {
            clone.fStyles.add(wikiStyle);
        }
        return clone;
    }

    public List<WikiStyle> getStyles() {
        return new ArrayList<WikiStyle>(this.fStyles);
    }

    public List<WikiParameter> getParams() {
        return this.fParams.toList();
    }

    public String toString() {
        return this.fStyles.toString();
    }
}

