/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class Strings {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private Strings() {
    }

    public static String stringFromBytes(byte[] bytes) {
        return Strings.stringFromBytes(bytes, DEFAULT_CHARSET);
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static byte[] bytesFromString(String str) {
        return Strings.bytesFromString(str, DEFAULT_CHARSET);
    }

    public static byte[] bytesFromString(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        return str.getBytes(charset);
    }

    public static String wrapIfLongestLineExceedsLimit(String s, int maxLineLength) {
        int longestLength = Strings.findLongestLineLength(s);
        if (longestLength > maxLineLength) {
            String wrapped = WordUtils.wrap((String)s, (int)maxLineLength, null, (boolean)true);
            return wrapped.replaceAll("(?m)^[ \t]*\r?\n", "");
        }
        return s;
    }

    private static int findLongestLineLength(String s) {
        String[] lines = s.split("\n");
        int longestLength = 0;
        for (String line : lines) {
            int length = line.length();
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }

    public static double normalisedLevenshteinDistance(String one, String two) {
        if (one == null || two == null) {
            return 1.0;
        }
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = StringUtils.getLevenshteinDistance((CharSequence)one, (CharSequence)two);
        return actualDistance / maxDistance;
    }

    public static String normaliseLineBreaks(String s) {
        return s.replace("\r\n", "\n").replace("\n", System.lineSeparator());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

