/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.HandlebarsException;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.TemplateModelDataProviderExtension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HttpTemplateCacheKey;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResponseTemplateTransformer
implements StubLifecycleListener,
ResponseDefinitionTransformerV2 {
    public static final String NAME = "response-template";
    private final boolean global;
    private final FileSource files;
    private final TemplateEngine templateEngine;
    private final List<TemplateModelDataProviderExtension> templateModelDataProviders;

    public ResponseTemplateTransformer(TemplateEngine templateEngine, boolean global, FileSource files, List<TemplateModelDataProviderExtension> templateModelDataProviders) {
        this.templateEngine = templateEngine;
        this.global = global;
        this.files = files;
        this.templateModelDataProviders = templateModelDataProviders;
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(ServeEvent serveEvent) {
        try {
            LoggedRequest request = serveEvent.getRequest();
            ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
            Parameters parameters = ParameterUtils.getFirstNonNull(responseDefinition.getTransformerParameters(), Parameters.empty());
            ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
            PathTemplate pathTemplate = serveEvent.getStubMapping().getRequest().getUrlMatcher().getPathTemplate();
            Map<String, Object> additionalModelData = this.templateModelDataProviders.stream().map(provider -> provider.provideTemplateModelData(serveEvent).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("parameters", parameters);
            model.put("request", RequestTemplateModel.from(request, pathTemplate));
            model.putAll(this.addExtraModelElements(request, responseDefinition, this.files, parameters));
            model.putAll(additionalModelData);
            if (responseDefinition.specifiesTextBodyContent()) {
                boolean isJsonBody = responseDefinition.getReponseBody().isJson();
                HandlebarsOptimizedTemplate bodyTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forInlineBody(responseDefinition), responseDefinition.getTextBody());
                this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate, isJsonBody);
            } else if (responseDefinition.specifiesBodyFile()) {
                HandlebarsOptimizedTemplate filePathTemplate = this.templateEngine.getUncachedTemplate(responseDefinition.getBodyFileName());
                String compiledFilePath = this.uncheckedApplyTemplate(filePathTemplate, model);
                boolean disableBodyFileTemplating = parameters.getBoolean("disableBodyFileTemplating", false);
                if (disableBodyFileTemplating) {
                    newResponseDefBuilder.withBodyFile(compiledFilePath);
                } else {
                    TextFile file = this.files.getTextFileNamed(compiledFilePath);
                    HandlebarsOptimizedTemplate bodyTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forFileBody(responseDefinition, compiledFilePath), file.readContentsAsString());
                    this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate, false);
                }
            }
            if (responseDefinition.getHeaders() != null) {
                List<HttpHeader> newResponseHeaders = responseDefinition.getHeaders().all().stream().map(header -> {
                    ArrayList<String> valueListBuilder = new ArrayList<String>();
                    int index = 0;
                    for (String headerValue : header.values()) {
                        HandlebarsOptimizedTemplate template = this.templateEngine.getTemplate(HttpTemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                        valueListBuilder.add(this.uncheckedApplyTemplate(template, model));
                    }
                    return new HttpHeader(header.key(), (Collection<String>)valueListBuilder);
                }).collect(Collectors.toList());
                newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
            }
            if (responseDefinition.getProxyBaseUrl() != null) {
                HandlebarsOptimizedTemplate proxyBaseUrlTemplate = this.templateEngine.getTemplate(HttpTemplateCacheKey.forProxyUrl(responseDefinition), responseDefinition.getProxyBaseUrl());
                String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
                ResponseDefinitionBuilder.ProxyResponseDefinitionBuilder newProxyResponseDefBuilder = newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
                if (responseDefinition.getAdditionalProxyRequestHeaders() != null) {
                    List<HttpHeader> newResponseHeaders = responseDefinition.getAdditionalProxyRequestHeaders().all().stream().map(header -> {
                        ArrayList<String> valueListBuilder = new ArrayList<String>();
                        int index = 0;
                        for (String headerValue : header.values()) {
                            HandlebarsOptimizedTemplate template = this.templateEngine.getTemplate(HttpTemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                            valueListBuilder.add(this.uncheckedApplyTemplate(template, model));
                        }
                        return new HttpHeader(header.key(), (Collection<String>)valueListBuilder);
                    }).collect(Collectors.toList());
                    HttpHeaders proxyHttpHeaders = new HttpHeaders(newResponseHeaders);
                    for (String key : proxyHttpHeaders.keys()) {
                        newProxyResponseDefBuilder.withAdditionalRequestHeader(key, proxyHttpHeaders.getHeader(key).firstValue());
                    }
                }
                return newProxyResponseDefBuilder.build();
            }
            return newResponseDefBuilder.build();
        }
        catch (HandlebarsException he) {
            String message = ResponseTemplateTransformer.cleanUpHandlebarsErrorMessage(he.getMessage());
            serveEvent.appendSubEvent(SubEvent.error(message));
            return WireMock.serverError().withHeader("Content-Type", "text/plain").withBody(message).build();
        }
    }

    private static String cleanUpHandlebarsErrorMessage(String rawMessage) {
        return rawMessage.replaceAll("inline@[a-z0-9]+:", "").replaceAll("\n.*", "");
    }

    protected Map<String, Object> addExtraModelElements(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        return Collections.emptyMap();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, Map<String, Object> model, HandlebarsOptimizedTemplate bodyTemplate, boolean isJsonBody) {
        String bodyString = this.uncheckedApplyTemplate(bodyTemplate, model);
        Body body = isJsonBody ? Body.fromJsonBytes(bodyString.getBytes(StandardCharsets.UTF_8)) : Body.fromOneOf(null, bodyString, null, null);
        newResponseDefBuilder.withResponseBody(body);
    }

    private String uncheckedApplyTemplate(HandlebarsOptimizedTemplate template, Object context) {
        return template.apply(context);
    }

    @Override
    public void afterStubRemoved(StubMapping stub) {
        this.templateEngine.invalidateCache();
    }

    @Override
    public void afterStubsReset() {
        this.templateEngine.invalidateCache();
    }

    public long getCacheSize() {
        return this.templateEngine.getCacheSize();
    }

    public Long getMaxCacheEntries() {
        return this.templateEngine.getMaxCacheEntries();
    }
}

