/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TemplatedUrlPath
extends LinkedHashMap<String, String>
implements Iterable<String> {
    private final String originalPath;

    public TemplatedUrlPath(String url, PathTemplate pathTemplate) {
        this.originalPath = Urls.getPath(url);
        this.addAllPathSegments();
        this.putAll(pathTemplate.parse(this.originalPath));
    }

    private void addAllPathSegments() {
        List<String> pathSegments = Urls.getPathSegments(this.originalPath);
        int i = 0;
        for (String pathNode : pathSegments) {
            if (!StringUtils.isNotEmpty((CharSequence)pathNode)) continue;
            String key = String.valueOf(i++);
            this.put(key, pathNode);
        }
    }

    @Override
    public String toString() {
        return this.originalPath;
    }

    @Override
    public Iterator<String> iterator() {
        return Urls.getPathSegments(this.originalPath).iterator();
    }
}

