/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty.JettyUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class JettyHttpsFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(StandardCharsets.UTF_8);
    private final Response response;
    private final Socket socket;

    public JettyHttpsFaultInjector(HttpServletResponse response) {
        this.response = JettyUtils.unwrapResponse(response);
        this.socket = JettyUtils.getTlsSocket(this.response);
    }

    @Override
    public void connectionResetByPeer() {
        try {
            this.socket.setSoLinger(true, 0);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.writeGarbageThenCloseSocket();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void randomDataAndCloseConnection() {
        this.writeGarbageThenCloseSocket();
    }

    private void writeGarbageThenCloseSocket() {
        this.response.getHttpOutput().getHttpChannel().getEndPoint().write(new Callback(){

            public void succeeded() {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    LocalNotifier.notifier().error("Failed to close socket after Garbage write succeeded", e);
                }
            }

            public void failed(Throwable x) {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    LocalNotifier.notifier().error("Failed to close socket after Garbage write failed", e);
                }
            }
        }, new ByteBuffer[]{BufferUtil.toBuffer((byte[])GARBAGE)});
    }
}

